import { Component, OnInit } from '@angular/core';
import { AddressService } from './../../config/address.service';
import { Router, ActivatedRoute } from '@angular/router';
import { Location } from '@angular/common';
import { ServiceService } from './../../config/service.service';


@Component({
  selector: 'app-address',
  templateUrl: './address.page.html',
  styleUrls: ['./address.page.scss']
})
export class AddressPage implements OnInit {
  custId: any;
  loader: boolean;
  constructor(
    private location: Location,
    public addressService: AddressService,
    public router: Router,
    public service: ServiceService,
  ) {
    this.loader = false;
    const users = this.service.get('user').then(data => {
      if (data) {
        data = JSON.parse(data);
        this.custId = data.uid;
        this.addressService.addList(data.uid);
      }
    });
  }

  ngOnInit() { }

  goBack() {
    this.location.back();
  }

  setDefault(addressId: any) {
    this.loader = true;
    console.log(addressId);
    this.addressService.setDefaultAddress(addressId, this.custId).then(() => {
      this.loader = false;
    }).catch(err => {
      this.loader = false;
      this.service.showToast('Something went wrong please try again!', 'top', 'my-error', 1000);
    });
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }
}
