import { Component, OnInit } from '@angular/core';
import { ModalController, NavParams } from '@ionic/angular';
import { OrdersService } from './../../config/order.service';

@Component({
  selector: 'app-deliverypop',
  templateUrl: './deliverypop.page.html',
  styleUrls: ['./deliverypop.page.scss'],
})
export class DeliverypopPage implements OnInit {
  currDate = new Date();
  params: any;
  orderId: string;
  constructor(
    private modalController: ModalController,
    private navParams: NavParams,
    public orderService: OrdersService
  ) { }

  ngOnInit() {
    this.params = this.navParams.data;
    console.log(this.navParams.data);
  }

  async closeModal() {
    const onClosedData = 'Wrapped Up!';
    await this.modalController.dismiss(onClosedData);
  }

  changeOrder(status: number) {
    this.orderId = this.params.orderId;
    this.orderService.changeOrder(this.orderId, status).then(() => {
      this.closeModal();
    });
  }

}
