import { Component, OnInit } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { AuthService } from './../../config/auth.service';
import { MenuController, Platform } from '@ionic/angular';
import { async } from 'q';

@Component({
  selector: 'app-login',
  templateUrl: './login.page.html',
  styleUrls: ['./login.page.scss']
})
export class LoginPage implements OnInit {
  subscription: any;
  constructor(
    private router: Router,
    private route: ActivatedRoute,
    public authService: AuthService,
    public menuCtrl: MenuController,
    private platform: Platform
  ) { }

  ngOnInit() { }

  ionViewWillEnter() {
    this.menuCtrl.enable(false);
  }

  ionViewDidEnter() {
    this.subscription = this.platform.backButton.subscribe(() => {
      console.log('cancelled');
      // tslint:disable-next-line:no-string-literal
      navigator['app'].exitApp();
    });
  }

  ionViewWillLeave() {
    this.subscription.unsubscribe();
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { replaceUrl: true, queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }
}
