import { Location } from '@angular/common';
import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { Router } from '@angular/router';
import { ModalController } from '@ionic/angular';
import { ProductsService } from './../../config/products.service';
import { SearchService } from './../../config/search.service';
import { ServiceService } from './../../config/service.service';

@Component({
  selector: 'app-searchmodal',
  templateUrl: './searchmodal.page.html',
  styleUrls: ['./searchmodal.page.scss']
})


export class SearchmodalPage implements OnInit {
  @ViewChild('searchText', { static: false }) searchText: ElementRef;
  searchShow = false;
  constructor(
    private modalController: ModalController,
    private searchService: SearchService,
    public service: ServiceService,
    private productsService: ProductsService,
    private router: Router,
    private location: Location,
  ) { }

  ngOnInit() {
    this.searchService.searchList = [];
  }

  ionViewWillEnter() {
    this.searchText.nativeElement.focus();
  }

  async closeModal() {
    /* await this.modalController.dismiss(); */
    this.location.back();
  }

  searchFun(data: string) {
    this.searchShow = true;
    this.searchService.search(data);
  }

  clickSearch() {
    this.searchShow = true;
    this.searchService.searchList = [];
  }

  viewPage(datas: any) {
    // this.closeModal();
    console.log(datas);
    let data;
    let url;
    if (datas.type === 'shopper') {
      data = datas.data;
      this.service.set('shopParams', data);
      url = 'productlist';
    } else if (datas.type === 'category') {
      data = datas.data;
      this.service.set('catParams', data);
      url = 'catstorelist';
    } else {
      data = datas.data;
      data.size = this.service.splitSep(data.size);
      data.tag = this.service.splitSep(data.tag);
      (data.color = this.service.splitSep(data.color)), (url = 'productdetail');
      this.productsService.setProd(data);
    }
    console.log('here');
    this.searchClose();
    this.router.navigateByUrl(url, { queryParams: data, replaceUrl: true });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  searchClose() {
    // this.closeModal();
    this.searchShow = false;
  }

  unEscape(text: string) {
    const respVal = unescape(text);
    return respVal.replace('�', '');
  }




}
