import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { ServiceService } from './../../config/service.service';
import { WishService } from './../../config/wish.service';
import { ProductsService } from './../../config/products.service';

@Component({
  selector: 'app-wishlist',
  templateUrl: './wishlist.page.html',
  styleUrls: ['./wishlist.page.scss']
})
export class WishlistPage implements OnInit {
  custId: any;
  loader: boolean;
  constructor(
    private location: Location,
    private router: Router,
    public service: ServiceService,
    public wishService: WishService,
    public prodService: ProductsService
  ) {
    this.loader = true;
    setTimeout(() => {
      this.loader = false;
    }, 2000);
    const users = this.service.get('user').then(data => {
      if (data) {
        data = JSON.parse(data);
        this.custId = data.uid;
        this.wishService.wishList(this.custId);
      }
    });
  }

  ngOnInit() { }

  goBack() {
    this.location.back();
  }

  clearAll() {
    this.loader = true;
    this.wishService
      .clearWish(this.custId)
      .then(data => {
        this.loader = false;
        this.service.showToast(
          'Wish list cleared successfully',
          'top',
          'my-toast',
          2000
        );
      })
      .catch(err => {
        this.loader = false;
        this.service.showToast('Something went wrong', 'top', 'my-error', 1000);
      });
  }

  async addToCart() {
    this.loader = true;
    let centerId = '';
    let state = false;
    await this.wishService.whishItem.forEach((item) => {
      if (centerId === '') {
        centerId = item.centerId;
      } else {
        if (centerId !== item.centerId) {
          state = true;
        }
      }
    });

    if (state === false) {
      this.wishService
        .addToCart(this.custId, this.wishService.whishItem)
        .then(data => {
          this.wishService
            .clearWish(this.custId)
            .then(datas => {
              this.loader = false;
              this.service.showToast('Added to cart', 'top', 'my-toast', 2000);
            })
            .catch(err => {
              this.loader = false;
              this.service.showToast(
                'Something went wrong',
                'top',
                'my-error',
                1000
              );
            });
        })
        .catch(err => {
          this.loader = false;
          this.service.showToast('Something went wrong', 'top', 'my-error', 1000);
        });
    } else {
      this.loader = false;
      this.service.showToast('You have selected products from different shopping centers', 'top', 'my-error', 2000);
    }
  }

  unEscape(text: string) {
    const regex = '%uFFFD';
    return unescape(text.replace(/%uFFFD/g, ''));
  }

  removeItem(prodId) {
    this.loader = true;
    this.wishService
      .clearWishItem(this.custId, prodId)
      .then(data => {
        this.loader = false;
        this.service.showToast(
          'Wish list cleared successfully',
          'top',
          'my-toast',
          2000
        );
      })
      .catch(err => {
        this.loader = false;
        this.service.showToast('Something went wrong', 'top', 'my-error', 1000);
      });
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  prodDetails(index: number) {
    console.log(this.wishService.whishItem[index]);
    this.prodService.setProd(this.wishService.whishItem[index]);
    this.router.navigateByUrl('productdetail');
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }
}
