import { Component } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { Platform } from '@ionic/angular';
import { SplashScreen } from '@ionic-native/splash-screen/ngx';
import { StatusBar } from '@ionic-native/status-bar/ngx';
import { AngularFirestore, AngularFirestoreDocument, AngularFirestoreCollection } from '@angular/fire/firestore';
import * as firebase from 'firebase';
import { ModalController } from '@ionic/angular';
import { DeliverypopPage } from './deliverypop/deliverypop.page';
import { AuthService } from './../config/auth.service';
import { ServiceService } from './../config/service.service';
import { CategoriesService } from './../config/category.service';


@Component({
  selector: "app-root",
  templateUrl: "app.component.html",
  styleUrls: ["app.component.scss"]
})
export class AppComponent {
  sec_active1 = true;
  sec_active2 = false;
  sec_active3 = false;
  sec_active4 = false;
  sec_active5 = false;
  sec_active6 = false;

  menuw: number;

  constructor(
    private platform: Platform,
    private splashScreen: SplashScreen,
    private statusBar: StatusBar,
    private router: Router,
    public afs: AngularFirestore,
    public modalController: ModalController,
    public authService: AuthService,
    public service: ServiceService,
    public categoryService: CategoriesService,
    private route: ActivatedRoute
  ) {
    this.initializeApp();
    this.orderState();
  }

  initializeApp() {
    this.platform.ready().then(() => {
      this.statusBar.styleDefault();
      this.statusBar.overlaysWebView(false);
      this.statusBar.show();
      this.statusBar.backgroundColorByHexString('#29285b');
    });
  }

  async finishpop(data: any) {
    const modal = await this.modalController.create({
      component: DeliverypopPage,
      componentProps: data
    });
    return await modal.present();
  }

  goToPage(path, data = null) {
    this.service.set("params", data);
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  setActive1() {
    this.sec_active1 = !this.sec_active1;
    this.sec_active2 = false;
    this.sec_active3 = false;
    this.sec_active4 = false;
    this.sec_active5 = false;
    this.sec_active6 = false;
  }
  setActive2() {
    this.sec_active2 = !this.sec_active2;
    this.sec_active1 = false;
    this.sec_active3 = false;
    this.sec_active4 = false;
    this.sec_active5 = false;
    this.sec_active6 = false;
  }
  setActive3() {
    this.sec_active3 = !this.sec_active3;
    this.sec_active1 = false;
    this.sec_active2 = false;
    this.sec_active4 = false;
    this.sec_active5 = false;
    this.sec_active6 = false;
  }
  setActive4() {
    this.sec_active4 = !this.sec_active4;
    this.sec_active1 = false;
    this.sec_active2 = false;
    this.sec_active3 = false;
    this.sec_active5 = false;
    this.sec_active6 = false;
  }
  setActive5() {
    this.sec_active5 = !this.sec_active5;
    this.sec_active1 = false;
    this.sec_active2 = false;
    this.sec_active3 = false;
    this.sec_active4 = false;
    this.sec_active6 = false;
  }
  setActive6() {
    this.sec_active6 = !this.sec_active6;
    this.sec_active1 = false;
    this.sec_active2 = false;
    this.sec_active3 = false;
    this.sec_active4 = false;
    this.sec_active5 = false;
  }

  getState() {
    return this.service.state;
  }

  orderState() {
    console.log("called");
    const custId = "WwHnLICVY2dvZGUHuKqasiTB91a2";
    firebase
      .firestore()
      .collection("orders")
      .where("custId", "==", custId)
      .onSnapshot(snapData => {
        snapData.docChanges().forEach(change => {
          if (change.type === "modified") {
            const data = change.doc.data();
            if (data.orderStatus === 7) {
              this.finishpop(data);
            }
          }
        });
      });

    /*



    .onSnapshot(function(snapshot) {
        snapshot.docChanges().forEach(function(change) {
            if (change.type === "added") {
                console.log("New city: ", change.doc.data());
            }
            if (change.type === "modified") {
                console.log("Modified city: ", change.doc.data());
            }
            if (change.type === "removed") {
                console.log("Removed city: ", change.doc.data());
            }
        });
    }); */
  }

  vieworder(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }
}
