import {Component, OnInit, ViewChild, ElementRef, NgZone} from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { MapsAPILoader, MouseEvent } from '@agm/core';
import { Address } from './../../config/services/address';
import { AddressService } from './../../config/address.service';
import { ServiceService } from './../../config/service.service';
import { NgForm } from '@angular/forms';
import * as firebase from 'firebase';
/* import { google } from '@agm/core/services/google-maps-types'; */

@Component({
  selector: 'app-nearby',
  templateUrl: './nearby.page.html',
  styleUrls: ['./nearby.page.scss']
})

export class NearbyPage implements OnInit {
  latitude: number;
  longitude: number;
  zoom: number;
  address: string;
  private geoCoder;
  addressForm: NgForm;
  addressData = new Address('', '', '', '', true, '', 0, '');
  successState: boolean;
  uid: string;
  type: any;
  public searchElementRef: ElementRef;

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location,
    private mapsAPILoader: MapsAPILoader,
    private ngZone: NgZone,
    public addressService: AddressService,
    public service: ServiceService
  ) {
    this.successState = false;
    this.type = 0;
    const users = this.service.get('user').then((data) => {
      if (data) {
        data = JSON.parse(data);
        this.uid = data.uid;
      }
    });

    this.service.get('type').then((data) => {
      this.type = data;
    });
  }

  ngOnInit() {
    // load Places Autocomplete
    this.mapsAPILoader.load().then(() => {
      this.setCurrentLocation();
      this.geoCoder = new google.maps.Geocoder();
    });
  }
  // google maps zoom level

  private setCurrentLocation() {
    if ('geolocation' in navigator) {
      navigator.geolocation.getCurrentPosition(position => {
        this.latitude = position.coords.latitude;
        this.longitude = position.coords.longitude;
        this.zoom = 8;
        this.getAddress(this.latitude, this.longitude);
      });
    }
  }

  markerDragEnd($event: MouseEvent) {
    console.log($event);
    this.latitude = $event.coords.lat;
    this.longitude = $event.coords.lng;
    this.getAddress(this.latitude, this.longitude);
  }

  getAddress(latitude, longitude) {
    this.geoCoder.geocode(
      { location: { lat: latitude, lng: longitude } },
      (results, status) => {
        console.log(results);
        console.log(status);
        if (status === 'OK') {
          if (results[0]) {
            this.zoom = 12;
            this.address = results[0].formatted_address;
            console.log(this.address);
          } else {
            window.alert('No results found');
          }
        } else {
          window.alert('Geocoder failed due to: ' + status);
        }
      }
    );
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    window.history.back();
  }

  onSubmit(data: any) {
    console.log(data);
    const postData: Address = {
      address: this.address,
      addressType: data.addressType,
      building: data.building,
      landmark: data.landmark,
      defaultVal: 0,
      uid: this.uid,
      latLng: new firebase.firestore.GeoPoint(this.latitude, this.longitude),
      status: true
    };
    this.addressService.addressCreate(postData);
    this.successState = true;
    setTimeout(() => {
      this.successState = false;
      if (this.type === 1) {
        this.service.set('type', 0);
        this.router.navigateByUrl('home', { queryParams: null });
      }
    }, 3000);
  }
}

interface Marker {
  lat: number;
  lng: number;
  label?: string;
  draggable: boolean;
}
