import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { trigger, transition, animate, style } from '@angular/animations';
import { Router, ActivatedRoute, NavigationExtras } from '@angular/router';
import { ProductsService } from './../../config/products.service';
import { ServiceService } from './../../config/service.service';
import { SearchService } from './../../config/search.service';

@Component({
  selector: 'app-productlist',
  templateUrl: './productlist.page.html',
  styleUrls: ['./productlist.page.scss'],
  animations: [
    trigger('slideInOut', [
      transition(':enter', [
        style({ transform: 'translateY(100%)' }),
        animate('200ms ease-in', style({ transform: 'translateY(0%)' }))
      ]),
      transition(':leave', [
        animate('200ms ease-out', style({ transform: 'translateY(100%)' }))
      ])
    ])
  ]
})
export class ProductlistPage implements OnInit {
  onGrid = false;
  isShow = false;
  data: any;
  searchShow = false;
  sortValue: string;

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location,
    public prodService: ProductsService,
    public service: ServiceService,
    public searchService: SearchService
  ) {
    this.service.get('params').then(val => {
      this.data = val;
      console.log(this.data);
      this.prodService.prodList(this.data.uid);
    });
  }

  ngOnInit() {}

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  istoggle() {
    this.isShow = !this.isShow;
  }

  goBack() {
    // this.location.back();
    window.history.back();
  }

  gridToggle() {
    this.onGrid = !this.onGrid;
  }

  clickSearch() {
    this.searchShow = true;
  }

  searchClose() {
    this.searchShow = false;
  }

  prodDetails(index: number) {
    this.prodService.setProd(this.prodService.product[index]);
    this.router.navigateByUrl('productdetail');
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  changeFav(index) {
    const state = this.prodService.fav.findIndex(x => x === index);
    console.log(state);
    console.log(this.prodService.fav);
    if (state > -1) {
      this.prodService.fav.splice(state, 1);
      this.prodService.changeFav(index, 'yes');
    } else {
      this.prodService.fav.push(index);
      this.prodService.changeFav(index, 'no');
    }
    return;
    console.log(this.prodService.fav);
  }

  setValue(value) {
    this.sortValue = value;
    console.log(this.sortValue);
  }

  submit() {
    console.log(this.sortValue);
    this.prodService.filterSearch(this.sortValue);
  }

  checkFavStatus(index) {
    const state = this.prodService.fav.findIndex(x => x === index);
    return state > -1 ? 'fav_fill' : 'fav_icon';
  }

  searchFun(data: string) {
    this.searchService.search(data);
  }

  viewPage(datas: any) {
    console.log(datas);
    let data;
    let url;
    if (datas.type === 'shopper') {
      data = datas.data;
      this.service.set('params', data);
      url = 'productlist';
    } else if (datas.type === 'category') {
      data = datas.data;
      this.service.set('params', data);
      url = 'catstorelist';
    } else {
      data = datas.data;
      data.size = this.service.splitSep(data.size);
      data.tag = this.service.splitSep(data.tag);
      (data.color = this.service.splitSep(data.color)), (url = 'productdetail');
      this.prodService.setProd(data);
    }
    this.searchClose();
    this.router.navigateByUrl(url, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }
}
