import { Component, OnInit } from "@angular/core";
import { trigger, transition, animate, style } from "@angular/animations";
import { Router } from "@angular/router";
import { Location } from "@angular/common";
import { ServiceService } from "./../../config/service.service";
import { ShoppersService } from "./../../config/shopper.service";

@Component({
  selector: "app-storelist",
  templateUrl: "./storelist.page.html",
  styleUrls: ["./storelist.page.scss"],
  animations: [
    trigger("slideInOut", [
      transition(":enter", [
        style({ transform: "translateY(100%)" }),
        animate("200ms ease-in", style({ transform: "translateY(0%)" }))
      ]),
      transition(":leave", [
        animate("200ms ease-out", style({ transform: "translateY(100%)" }))
      ])
    ])
  ]
})
export class StorelistPage implements OnInit {
  searchShow = false;
  slideOpts = {
    slidesPerView: 1.5
  };
  data: any;

  constructor(
    public router: Router,
    public location: Location,
    public service: ServiceService,
    public shopperService: ShoppersService
  ) {
    this.service.get("params").then(val => {
      this.data = val;
      this.shopperService.shopperList(this.data.cId, "centerId");
    });
  }

  ngOnInit() {}

  goToPage(path, data = null) {
    this.service.set("params", data);
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.location.back();
  }

  clickSearch() {
    this.searchShow = true;
  }

  searchClose() {
    this.searchShow = false;
  }
}
