import { Component, OnInit, ViewChild, } from '@angular/core';
import { IonSlides } from '@ionic/angular';
import { Router, ActivatedRoute } from '@angular/router';

@Component({
  selector: 'app-landing',
  templateUrl: './landing.page.html',
  styleUrls: ['./landing.page.scss'],
})
export class LandingPage implements OnInit {

  @ViewChild(IonSlides, { static: false })slides: IonSlides;
  currentIndex: any;
  constructor(private router: Router, private route: ActivatedRoute) { }

  ngOnInit() {
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  slideOpts = {
    initialSlide: 0,
    speed: 1000,
    allowTouchMove: false
  };


  next() {
    this.slides.slideNext();
  }

  prev() {
    this.slides.slidePrev();
  }

  slideChanged() {
    this.slides.getActiveIndex().then(index => {
      this.currentIndex = index;
      console.log(this.currentIndex);

    });
  } 

}
