 <?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Cars extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Cars_model');
        $this->load->helper('access');
        if (!$this->session->userdata('logged_in')) {
            redirect(base_url());
        }
        $class = $this->router->fetch_class();
        $method = $this->router->fetch_method();
        $r = check_access($class,$method);
        // $r);exit();
        if($r == false)
        {
            redirect(base_url().'welcome/error_404');
        }
    }
    
    
    
    
    public function save_carmake()
    {
        $template['page']       = 'Cars/add-cars';
        $template['page_title'] = "Create Cars";
        if ($_POST) {
            $data = $_POST;
            unset($data['submit']);
            $result = $this->Cars_model->save_carmake($data);
            
            if ($result == "Exist") {
                $this->session->set_flashdata('message', array(
                    'message' => 'Car already Exist',
                    'class' => 'danger'
                ));
            } else {
                $this->session->set_flashdata('message', array(
                    'message' => 'Car added successfully',
                    'class' => 'success'
                ));
                
            }
            redirect(base_url() . 'Cars/save_carmake');
        } else {
            $template['data'] = $this->Cars_model->get_allcars();
            $this->load->view('template', $template);
        }
    }
    
    
    public function delete_car()
    {
        $id     = $this->uri->segment(3);
        $result = $this->Cars_model->car_delete($id);
        $this->session->set_flashdata('message', array(
            'message' => 'Requested Car Deleted Successfully',
            'class' => 'success'
        ));
        redirect(base_url() . 'Cars/save_carmake');
    }

    public function edit_carmake($id){
        if($id != ''){
            $template['datas'] = $this->Cars_model->get_carmake_byid($id);
            if(isset($_POST) && !empty($_POST)){
                $data = $_POST;
                $result = $this->Cars_model->edit_carmake($data,$id);
                if($result){
                    $this->session->set_flashdata('message', array('message' => 'Requested Car Edited Successfully','class' => 'success'));
                    redirect(base_url() . 'Cars/save_carmake');
                }else{
                     $this->session->set_flashdata('message', array('message' => 'Sorry Requested Car is not deleted','class' => 'danger'));
                     redirect(base_url() . 'Cars/save_carmake');
                }
            }
        }
        $template['page']       = 'Cars/add-cars';
        $template['page_title'] = "Edit Cars";
        $template['data'] = $this->Cars_model->get_allcars();
        $this->load->view('template', $template);
    }
    
    
    public function save_carcolor()
    {
        $template['page']       = 'Cars/add-color';
        $template['page_title'] = "Create CarColor";
        if ($_POST) {
            $data = $_POST;
            unset($data['submit']);
            $result = $this->Cars_model->save_carcolor($data);
            
            if ($result == "Exist") {
                $this->session->set_flashdata('message', array(
                    'message' => 'CarColor already Exist',
                    'class' => 'danger'
                ));
            } else {
                $this->session->set_flashdata('message', array(
                    'message' => 'CarColor added successfully',
                    'class' => 'success'
                ));
                
            }
            redirect(base_url() . 'Cars/save_carcolor');
        } else {
            $template['data'] = $this->Cars_model->get_allcarcolor();
            $this->load->view('template', $template);
        }
    }


    public function edit_carcolor($id){
        if($id != ''){
            $template['datas'] = $this->Cars_model->get_carcolor_byid($id);
            if(isset($_POST) && !empty($_POST)){
                $data = $_POST;
                $result = $this->Cars_model->edit_carcolor($data,$id);
                if($result){
                    $this->session->set_flashdata('message', array( 'message' => 'Requested CarColor Edited Successfully','class' => 'success'));
                     redirect(base_url() . 'Cars/save_carcolor');
                }else{
                     $this->session->set_flashdata('message', array( 'message' => 'Requested CarColor not Edited','class' => 'danger'));
                      redirect(base_url() . 'Cars/save_carcolor');
                }
            }
        }
        $template['page']       = 'Cars/add-color';
        $template['page_title'] = "Edit CarColor";
        $template['data'] = $this->Cars_model->get_allcarcolor();
        $this->load->view('template', $template);
    }
    
    
    
    
    
    
    
     public function save_cartype()
    {
        $template['page']       = 'Cars/add-type';
        $template['page_title'] = "Create CarType";
        if ($_POST) {
            $data = $_POST;
         
            unset($data['submit']);
            $result = $this->Cars_model->save_cartype($data);
            
            if ($result == "Exist") {
                $this->session->set_flashdata('message', array(
                    'message' => 'CarType already Exist',
                    'class' => 'danger'
                ));
            } else {
                $this->session->set_flashdata('message', array(
                    'message' => 'CarType added successfully',
                    'class' => 'success'
                ));
                
            }
            redirect(base_url() . 'Cars/save_cartype');
        } else {
            $template['data'] = $this->Cars_model->get_allcartype();
            $this->load->view('template', $template);
        }
    }


    public function edit_cartype($id){
        if($id != ''){
            $template['datas'] = $this->Cars_model->get_cartype_byid($id);
            if(isset($_POST) && !empty($_POST)){
                $data = $_POST;
                $result = $this->Cars_model->edit_cartype($data,$id);
                if($result){
                    $this->session->set_flashdata('message', array('message' => 'Requested CarType Edited successfully','class' => 'success'));
                    redirect(base_url() . 'Cars/save_cartype');
                }else{
                    $this->session->set_flashdata('message', array('message' => 'Sorry, Requested Cartype is not Edited','class' => 'danger'));
                    redirect(base_url() . 'Cars/save_cartype');
                }
            }
        }
        $template['page']       = 'Cars/add-type';
        $template['page_title'] = "Edit CarType";
        $template['data'] = $this->Cars_model->get_allcartype();
        $this->load->view('template', $template);
    }
    
    
    
       public function delete_cartype()
    {
        $id     = $this->uri->segment(3);
        $result = $this->Cars_model->cartype_delete($id);
        $this->session->set_flashdata('message', array(
            'message' => 'Requested CarType Deleted Successfully',
            'class' => 'success'
        ));
        redirect(base_url() . 'Cars/save_cartype');
    }
    
    
    
    public function delete_carcolor()
    {
        $id     = $this->uri->segment(3);
        $result = $this->Cars_model->carcolor_delete($id);
        $this->session->set_flashdata('message', array(
            'message' => 'Requested CarColor Deleted Successfully',
            'class' => 'success'
        ));
        redirect(base_url() . 'Cars/save_carcolor');
    }
    
    
    
    
    
    
} 