 <?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Adminuser extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Adminuser_model');
        $this->load->model('Role_model');
        $this->load->helper('access');
        if (!$this->session->userdata('logged_in')) {
            redirect(base_url());
        }
        $class = $this->router->fetch_class();
        $method = $this->router->fetch_method();
        $r = check_access($class,$method);
        if($r == false)
        {
            redirect(base_url().'welcome/error_404');
        }
    }
    
    
    
    public function index(){
        $template['page']       = 'Adminusers/viewuser';
        $template['page_title'] = "Create Users";

        $template['data'] = $this->Adminuser_model->get_allusers();
        $this->load->view('template', $template);
    }

    public function create_user()
    {
        if(isset($_POST) && !empty($_POST)){

            $data = $_POST;
            if(!empty($_FILES)) {
                 //$data=$_POST;die;
                $fileName =$_FILES['file']['name'];
                $fileName = str_replace('%','a',$fileName);
                $fileName = 'tukkibi'.'_'.time().".".$fileName;
                $config = set_upload_options('./assets/uploads/profile_pic/'); 
                $config['file_name'] = $fileName;
                $this->load->library('upload', $config);
                if (!$this->upload->do_upload('file')) {
                    $error = array('error' => $this->upload->display_errors('', '')); 
                    $res = array(
                            "status"=> "error",
                            "error"=> "Upload Error",
                            "message"=> "Sorry! Promocode Image not uploaded".$error['error']
                        );
                }   
                else {                          
                    $imagedata = $this->upload->data(); 
                    $data['profile_picture']= '/assets/uploads/profile_pic/'.$imagedata['file_name'];
                }
            }
            $result = $this->Adminuser_model->insert_user($data);
            if($result){
                $this->session->set_flashdata('message', array('message' => 'Adminuser added successfully','class' => 'success'));
            }else{
                $this->session->set_flashdata('message', array('message' => 'Sorry, Not Added','class' => 'danger'));
            }
        }
        $template['page']       = 'Adminusers/adduser';
        $template['page_title'] = "Create Users";

        $template['data'] = $this->Role_model->get_allroles();
        $template['data1'] = $this->Adminuser_model->get_allusers();
        $this->load->view('template', $template);
    }

    public function edit_user($id){

        $template['data1'] = $this->Adminuser_model->get_users_by_id($id);
        if(isset($_POST) && !empty($_POST)){
            $data = $_POST;
             if(!empty($_FILES)) {
                $fileName =$_FILES['file']['name'];
                $fileName = str_replace('%','a',$fileName);
                $fileName = 'tukkibi'.'_'.time().".".$fileName;
                $config = set_upload_options('./assets/uploads/profile_pic/'); 
                $config['file_name'] = $fileName;
                $this->load->library('upload', $config);
                if (!$this->upload->do_upload('file')) {
                    $error = array('error' => $this->upload->display_errors('', '')); 
                    $res = array(
                            "status"=> "error",
                            "error"=> "Upload Error",
                            "message"=> "Sorry! Promocode Image not uploaded".$error['error']
                        );
                }   
                else {                          
                    $imagedata = $this->upload->data(); 
                   $data['profile_picture']= '/assets/uploads/profile_pic/'.$imagedata['file_name'];
                }
            }else{
                $data['profile_picture'] = $template['data1']->profile_picture;
            }
            $result = $this->Adminuser_model->edit_user($data,$id);
            if($result){
                $this->session->set_flashdata('message', array('message' => 'Adminuser Edited successfully','class' => 'success'));
                 redirect(base_url() . 'Adminuser/create_user');
            }else{
                $this->session->set_flashdata('message', array('message' => 'Adminuser is not Edited successfully','class' => 'danger'));
                 redirect(base_url() . 'Adminuser/create_user');
            }
        }
        $template['page']       = 'Adminusers/edituser';
        $template['page_title'] = "Edit Users";

        $template['data'] = $this->Role_model->get_allroles();
        $this->load->view('template', $template);
    }

    public function delete_user($id){
        $result = $this->Adminuser_model->delete_user($id);
        if($result){
            $this->session->set_flashdata('message', array('message' => 'User Deleted successfully','class' => 'success'));
        }else{
            $this->session->set_flashdata('message', array('message' => 'Sorry Users Not Deleted','class' => 'danger'));
        }
         redirect(base_url() . 'Adminuser/create_user');
    }

    public function role_manage($id){
      //  echo "dfgd";exit();
        // $this->session->userdata('admin'));exit();
        if($this->session->userdata('admin') == 1){

            $template['page'] = "Adminusers/role_management";
            $template['page_title'] = "Add role";
            $newarray = array();
            $template['access'] = $this->Adminuser_model->get_access($id);
            $rs = $this->Adminuser_model->get_details();
            foreach ($rs as $row) {
                $result = $this->Adminuser_model->get_functions($row->id);
                $row->functions = $result;
                $newarray[] = $row;
            }
            $template['newarray'] = $newarray;
            $this->load->view('template', $template); 
        }
    }

    public function update_role(){
        $data = $_POST;

        $id = $data['id'];
        unset($data['id']);
        $new =array();
        $newarray = array();

        foreach ($data as $rs) {
            $var = implode(',',$rs);
            $new[] = $var; 
        }
        foreach ($new as $value) {
            $neww = implode(',',$new);
            $newarray = $neww;
        }

        if(empty($newarray)):
            $newarray = NULL;
        endif;  
          // $newarray);
        $role = $this->Adminuser_model->update_role($newarray,$id);
        echo $role;
    }
    
    
    
    
    
    
    
    
    
} 