 <?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Role extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Role_model');
        $this->load->model('Adminuser_model');
          $this->load->helper('access');
        if (!$this->session->userdata('logged_in')) {
            redirect(base_url());
        }
        $class = $this->router->fetch_class();
        $method = $this->router->fetch_method();
        $r = check_access($class,$method);
        if($r == false)
        {
            redirect(base_url().'welcome/error_404');
        }
    }
    
    public function index()
    {
        if(isset($_POST) && !empty($_POST)){
            $data = $_POST;
            $result = $this->Role_model->insert_role($data);
            if($result){
                $this->session->set_flashdata('message', array('message' => 'Role added successfully','class' => 'success'));
            }else{
                $this->session->set_flashdata('message', array('message' => 'Sorry Role not Added','class' => 'danger'));
            }
        }
        $template['page']       = 'Roles/addrole';
        $template['page_title'] = "Add Role";
        $template['data'] = $this->Role_model->get_allroles();
        $this->load->view('template', $template);
    }

    public function delete_role($id){
        $result = $this->Role_model->delete_role($id);
        if($result){
            $this->session->set_flashdata('message', array('message' => 'Role Deleted successfully','class' => 'success'));
        }else{
            $this->session->set_flashdata('message', array('message' => 'Sorry Roles Not Deleted','class' => 'danger'));
        }
         redirect(base_url() . 'Role');
    }

    public function edit_role($id){
        if($id != ''){
            $template['datas'] = $this->Role_model->get_roles($id);
            $template['page']       = 'Roles/addrole';
            $template['page_title'] = "Add Role";
            if(isset($_POST) && !empty($_POST)){
            $data = $_POST;
            $result = $this->Role_model->update_role($id,$data);
            if($result){
                $this->session->set_flashdata('message', array('message' => 'Role Updated successfully','class' => 'success'));
                 redirect(base_url() . 'Role');
            }else{
                $this->session->set_flashdata('message', array('message' => 'Sorry Role not Updated','class' => 'danger'));
                 redirect(base_url() . 'Role');
                }
            }
        }
        $template['data'] = $this->Role_model->get_allroles();
        $this->load->view('template', $template);
        
    }

    public function role_manage($id){

        if($this->session->userdata('admin') == 1){

            $template['page'] = "Adminusers/role_management";
            $template['page_title'] = "Add role";
            $newarray = array();
            $template['access'] = $this->Adminuser_model->get_access($id);
            $rs = $this->Adminuser_model->get_details();
            foreach ($rs as $row) {
                $result = $this->Adminuser_model->get_functions($row->id);
                $row->functions = $result;
                $newarray[] = $row;
            }
            $template['newarray'] = $newarray;
            $this->load->view('template', $template); 
        }
    }

    
    
    
    
    
    
    
    
    
} 