import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { BehaviorSubject } from 'rxjs/BehaviorSubject';

@Injectable()
export class SubjectService {
    private locSubject = new BehaviorSubject<any>(null);
    private docSubjects = new BehaviorSubject<any>(null);
    private querySubjects = new BehaviorSubject<any>(null);


    sendLocData(searchData: any) {
        this.locSubject.next(searchData);
    }

    getLocData(): Observable<any> {
        return this.locSubject.asObservable();
    }

    sendDocData(docData: any) {
        this.docSubjects.next(docData);
    }

    getDocData(): Observable<any> {
        return this.docSubjects.asObservable();
    }

    sendQueryData(queryData: any) {
        this.querySubjects.next(queryData);
    }

    getQueryData(): Observable<any> {
        return this.querySubjects.asObservable();
    }

}