import { BrowserModule } from '@angular/platform-browser';
import { ErrorHandler, NgModule } from '@angular/core';
import { IonicApp, IonicErrorHandler, IonicModule } from 'ionic-angular';

import { MyApp } from './app.component';

import { StatusBar } from '@ionic-native/status-bar';
import { SplashScreen } from '@ionic-native/splash-screen';

import { Network } from '@ionic-native/network';
import { OneSignal } from '@ionic-native/onesignal';
import { LocationAccuracy } from '@ionic-native/location-accuracy';
import { Myservice } from "../providers/myservice";
import { HttpModule } from "@angular/http";
import { IonicStorageModule } from '@ionic/storage';
import { OrderbyPipe } from '../providers/sort-pipe';
import { Geolocation } from '@ionic-native/geolocation';
import { fireService } from "../providers/firebase.service";
import { AngularFireDatabase } from 'angularfire2/database';
import { AngularFireModule } from 'angularfire2';
import { dataService } from "../providers/common.service";
import { DatePipe } from '@angular/common';
import * as firebase from "firebase";
import { LocalNotifications } from '@ionic-native/local-notifications';
import { Toast } from '@ionic-native/toast';
import { PhotoViewer } from '@ionic-native/photo-viewer';
import { FileOpener } from '@ionic-native/file-opener';
import { FileTransfer } from '@ionic-native/file-transfer';
import { File } from '@ionic-native/file';

export const firebaseConfig = {
  apiKey: "AIzaSyDLrbLd4RCCh86xuTVu7-cfJ28We_cG1sU",
  authDomain: "callmycab-205809.firebaseapp.com",
  databaseURL: "https://callmycab-205809.firebaseio.com",
  projectId: "callmycab-205809",
  storageBucket: "callmycab-205809.appspot.com",
  messagingSenderId: "151146703576"
};
firebase.initializeApp(firebaseConfig);

@NgModule({
  declarations: [
    MyApp
  ],
  imports: [
    BrowserModule,
    IonicModule.forRoot(MyApp),
    HttpModule,
    IonicStorageModule.forRoot(),
    AngularFireModule.initializeApp(firebaseConfig),
  ],
  bootstrap: [IonicApp],
  entryComponents: [
    MyApp
  ],
  providers: [
    StatusBar,
    SplashScreen,
    {provide: ErrorHandler, useClass: IonicErrorHandler},
    Network,
    OneSignal,
    LocationAccuracy,
    Myservice,
    OrderbyPipe,
    Geolocation,
    fireService,
    AngularFireDatabase,
    dataService,
    DatePipe,
    LocalNotifications,
    Toast,
    PhotoViewer,
    FileOpener,
    FileTransfer,
    File,
  ]
})
export class AppModule {}
