import { Component } from '@angular/core';
import { IonicPage, NavController, NavParams, Events } from 'ionic-angular';
import { Storage } from "@ionic/storage";
import { Myservice } from "../../providers/myservice";
import { dataService } from "../../providers/common.service";

@IonicPage()
@Component({
  selector: 'page-home',
  templateUrl: 'home.html',
})
export class HomePage {
  tab: any;
  upcoming: any;
  completed: any;
  baseurl = this.myservice.base_url

  constructor(public navCtrl: NavController, public navParams: NavParams, private storage: Storage, private myservice: Myservice, private data: dataService, public events: Events) {
  }

  ionViewDidEnter() {

    this.events.publish('driver:locOn', '');

    if (this.navParams.get('id'))
      this.navCtrl.push('QuickridePage', { id: this.navParams.get('id'), from: this.navParams.get('from') })
    else {
      this.myservice.show_loader()
      this.storage.get('driver_data').then(data => {
        if (data) {
          this.myservice.load_post({ id: data.id }, 'getMyRides').subscribe(response => {
            this.myservice.hide_loader()
            if (response.status == 'success') {
              this.upcoming = response.data.upcoming
              this.completed = response.data.completed
            }
            else
            this.myservice.show_alert('',response.message)
          })
        }
      })
    }
  }

  ionViewDidLoad() {
    this.tab = "active";
  }


  tab_swap(type) {
    this.tab = type;
  }

  rideDetails(data) {
    this.data.setrideData(data)
    this.navCtrl.push('RidedetailsPage')
    // this.navCtrl.setRoot('QuickridePage', { id: '38'})
    // this.events.publish('driver:locOn','')
  }
}
