import { Component } from '@angular/core';
import { IonicPage, NavController, NavParams, Platform } from 'ionic-angular';
import { dataService } from "../../providers/common.service";
import { Myservice } from "../../providers/myservice";
import * as firebase from 'firebase';
import { DatePipe } from '@angular/common';
declare var google;

@IonicPage()
@Component({
  selector: 'page-payment',
  templateUrl: 'payment.html',
})
export class PaymentPage {

  book = this.data.getrideData()
  geocoder: any;
  public unregisterBackButtonAction: any;
  ride: any;
  waypoints = this.data.getwaypointData()
  rate = this.data.getrateData();
  details:any;

  constructor(public navCtrl: NavController, public navParams: NavParams, private data: dataService, private myservice: Myservice, public platform: Platform, private datePipe: DatePipe) {
  }

  ionViewDidEnter() {
    // this.myservice.hide_loader();
    this.initializeBackButtonCustomHandler();

    console.log(this.book)

    var directionsService = new google.maps.DirectionsService;

    var pick = this.book.pickup_latlng.split(',')
    var drop = this.book.drop_latlng.split(',')

    var start = new google.maps.LatLng(Number(pick[0]), Number(pick[1]));
    var dest = new google.maps.LatLng(Number(drop[0]), Number(drop[1]));

    var This = this

    directionsService.route({
      origin: start,
      destination: dest,
      travelMode: 'DRIVING',
      waypoints: This.waypoints
    }, function (response, status) {
      if (status === 'OK') {
        var totalDist = 0;
        var myroute = response.routes[0];
        console.log(myroute)
        for (let i = 0; i < myroute.legs.length; i++) {
          totalDist += myroute.legs[i].distance.value;
        }
        totalDist = totalDist / 1000.
        console.log(totalDist)

        if (totalDist > This.rate.intialkm){
          var extra = totalDist - This.rate.intialkm
          var rate = ((extra * This.rate.standardrate) + (This.rate.intailrate)) + This.book.timeAmount
          var amount = rate
          rate = rate - This.book.discount
        }
        else{
          var rate = This.rate.intailrate + This.book.timeAmount;
          var amount = rate
          rate = rate - This.book.discount
        }

        var h = Math.floor(This.book.seconds / 3600);
        var m = Math.floor(This.book.seconds % 3600 / 60);

        var hDisplay = h > 0 ? h + "h" : "";
        var mDisplay = m > 0 ? m + "min" : "";

        var data = { 'id': This.book.id ,'pickup_time': This.datePipe.transform(This.book.actualPick, 'h:mm a'), 'drop_time': This.datePipe.transform(This.book.actualDrop, 'h:mm a'), 'drop_date': This.datePipe.transform(This.book.actualDrop, 'MM/dd/yyyy'), 'distance': totalDist, 'amount': rate, 'km': totalDist}

        console.log(data);
        This.myservice.load_post({data},'updateRideDetails').subscribe(response=>{
          This.myservice.hide_loader();
          if(response.status == 'success'){
            This.details = response.data;
            This.details.bfor_deduction = amount;
            This.details.hours = hDisplay + mDisplay;
          }
          else
          This.myservice.show_alert('',response.message)
        })
      } else {
        window.alert('Directions request failed due to ' + status);
      }
    });

  }

  public initializeBackButtonCustomHandler(): void {
    this.unregisterBackButtonAction = this.platform.registerBackButtonAction(() => {
      // this.customHandleBackButton();
    }, 10);
  }

  ionViewWillLeave() {
    this.unregisterBackButtonAction && this.unregisterBackButtonAction();
  }

  done() {
    this.myservice.load_post({ status: 'Completed', id: this.book.id }, 'changeStatus').subscribe(resp=>{
      if(resp.status == 'success'){
        this.navCtrl.setRoot('HomePage')
      }
    })
  }

}
