import { Component } from '@angular/core';
import { IonicPage, NavController, NavParams, ModalController, AlertController } from 'ionic-angular';
import { Myservice } from "../../providers/myservice";
import { Storage } from "@ionic/storage";
import { driver } from "../../models/mymodel";
import { dataService } from "../../providers/common.service";
import { Toast } from "@ionic-native/toast";

@IonicPage()
@Component({
  selector: 'page-quickride',
  templateUrl: 'quickride.html',
})
export class QuickridePage {
  bookingId = this.navParams.get('id')
  rideDetail: any;
  local: driver
  baseUrl = this.myservice.base_url

  constructor(public navCtrl: NavController, public navParams: NavParams, private myservice: Myservice, private storage: Storage, private data: dataService, private toast: Toast, private modalCtrl: ModalController, public alertCtrl: AlertController) {
  }

  ionViewDidEnter() {

    this.storage.get('driver_data').then(data => {
      if (data) {
        this.local = data;
      }
    })

    this.myservice.load_post({ id: this.bookingId }, 'getBookingDetails').subscribe(resp => {
      if (resp.status == 'success') {
        this.rideDetail = resp.data

        var tempf = this.rideDetail.pickup_area.split(',')

        this.rideDetail.from = tempf[0]
        this.rideDetail.fromAd = this.rideDetail.pickup_area
        this.rideDetail.timestamp = new Date(this.rideDetail.pickup_date + ' ' + this.rideDetail.pickup_time).getTime()

        var temp = this.rideDetail.drop_area.split(',')
        this.rideDetail.to = temp[0]
        this.rideDetail.toAd = this.rideDetail.drop_area

        this.data.setrideData(this.rideDetail)
      }
      else
      this.myservice.show_alert('',resp.message)
    })
  }

  accept() {
    this.myservice.load_post({ bookingId: this.bookingId, driverId: this.local.id }, 'rideAccept').subscribe(resp => {
      if (resp.status == 'success') {
        this.toast.show(resp.message, '2000', 'center').subscribe(toast => {
          console.log(toast);
        });
        this.navCtrl.pop()
      }
      else {
        this.myservice.show_alert('', resp.message)
      }
    })
  }

  reject() {
    let modal = this.modalCtrl.create('RejectPage', { bookId: this.bookingId })
    modal.onDidDismiss(data => {
      if (data) {
        const alert = this.alertCtrl.create({
          title: 'Success',
          message: data,
          buttons: [
            {
              text: 'Ok',
              handler: data => {
                this.navCtrl.setRoot('HomePage')
              }
            }
          ]
        });
        alert.present();
      }
    })
    modal.present();
  }

  pick() {
    this.myservice.show_loader()
    this.navCtrl.push('UserlocationPage')
  }

  back() {
    this.navCtrl.pop()
  }
}
