import { Component } from '@angular/core';
import { IonicPage, NavController, NavParams,ViewController } from 'ionic-angular';
import { Myservice } from '../../providers/myservice';
import { Storage } from "@ionic/storage";
import { driver } from "../../models/mymodel";

@IonicPage()
@Component({
  selector: 'page-reject',
  templateUrl: 'reject.html',
})
export class RejectPage {
  reason:any;
  local:driver

  constructor(public navCtrl: NavController, public navParams: NavParams, public viewctrl: ViewController, private myservice: Myservice, private storage:Storage) {
  }

  ionViewDidEnter() {
    this.storage.get('driver_data').then(data=>{
      if(data)
      this.local = data
    })
  }

  dismiss(){
    this.viewctrl.dismiss();
  }

  submit(){
    var booking_id = this.navParams.get('bookId');

    this.myservice.load_post({ booking_id: booking_id, driver_id: this.local.id, comment: this.reason }, 'rideReject').subscribe(response => {
      if (response.status == 'success') {
        this.viewctrl.dismiss(response.message);
      }
      else {
        this.myservice.show_alert('Error', response.message)
      }
    })
    
  }
}
