import { Component } from '@angular/core';
import { IonicPage, NavController, NavParams } from 'ionic-angular';
import { Myservice } from "../../providers/myservice";
import { dataService } from "../../providers/common.service";
import { DatePipe } from '@angular/common';

@IonicPage()
@Component({
  selector: 'page-ridedetails',
  templateUrl: 'ridedetails.html',
})
export class RidedetailsPage {
  details = this.data.getrideData()
  baseurl = this.myservice.base_url
  now:any;
  // rideDate:any
  temp:boolean = false;

  constructor(public navCtrl: NavController, public navParams: NavParams, private myservice: Myservice, private data: dataService, private datePipe: DatePipe) {
   
  }

  ionViewDidEnter(){
    this.now = this.datePipe.transform(new Date(), 'MM/dd/yyyy')

    if (this.now == this.details.pickup_date){
      this.temp = true;
    }
  }

  ionViewDidLoad() {
    var tempf = this.details.pickup_area.split(',')
    this.details.from = tempf[0]
    this.details.fromAd = this.details.pickup_area
    this.details.timestamp = new Date(this.details.pickup_date + ' ' + this.details.pickup_time).getTime()

    var temp = this.details.drop_area.split(',')
    this.details.to = temp[0]
    this.details.toAd = this.details.drop_area
    console.log(this.details)

    this.details.discount = Number(this.details.discount)

    this.data.setrideData(this.details)
  }

  back(){
  	this.navCtrl.pop();
  }

  pick(){
    this.myservice.show_loader()
    this.navCtrl.push('UserlocationPage')
  }

}
