import { Component } from '@angular/core';
import { IonicPage, NavController, NavParams } from 'ionic-angular';
import { Myservice } from "../../providers/myservice";
import { dataService } from "../../providers/common.service";
import { Storage } from "@ionic/storage";
import { driver } from "../../models/mymodel";

@IonicPage()
@Component({
  selector: 'page-uploaddoc',
  templateUrl: 'uploaddoc.html',
})
export class UploaddocPage {
  docs:any;
  local:driver

  constructor(public navCtrl: NavController, public navParams: NavParams, private myservice: Myservice, private comService:dataService, private storage:Storage) {
  }

  ionViewDidEnter(){
    this.storage.get('driver_data').then(data=>{
      this.local = data

      this.myservice.load_post({id:this.local.id},'getAllDocument').subscribe(resp=>{
        if(resp.status == 'success'){
          this.docs = resp.data
        }
        else
        this.myservice.show_alert('',resp.message)
      })
    })
  }

  uploadDoc(data){
    this.comService.setdocData(data);
    this.myservice.show_loader()
    this.navCtrl.push("DocupdatePage", { title: data.document_type});
  }

}
