import { Component, ViewChild } from '@angular/core';
import { Nav, Platform,AlertController,Events } from 'ionic-angular';
import { StatusBar } from '@ionic-native/status-bar';
import { SplashScreen } from '@ionic-native/splash-screen';
import { Network } from '@ionic-native/network';
import { OneSignal } from '@ionic-native/onesignal';
import { LocationAccuracy } from '@ionic-native/location-accuracy';
import { Storage } from "@ionic/storage";
import { Myservice } from "../providers/myservice";
import { driver } from "../models/mymodel";
@Component({
  templateUrl: 'app.html'
})
export class MyApp {
  @ViewChild(Nav) nav: Nav;

  rootPage: any = "LandingPage";

  pages: Array<{title: string, component: any}>;
  local:driver

  constructor(public platform: Platform, public statusBar: StatusBar, public splashScreen: SplashScreen, private network: Network, private alertCtrl: AlertController, private oneSignal: OneSignal, private locationAccuracy: LocationAccuracy, private storage: Storage, private myservice: Myservice, public events: Events) {
    this.initializeApp();


  }

  initializeApp() {
    this.platform.ready().then(() => {
      // this.initOnesignal();
      this.statusBar.styleDefault();
      this.splashScreen.hide();

      let disconnectSubscription = this.network.onDisconnect().subscribe(() => {
        const alert = this.alertCtrl.create({
          title: 'Network Error',
          message: 'No Internet Connection',
          buttons: [
            {
              text: 'Quit',
              handler: data => {
                this.platform.exitApp();
              }
            }, {
              text: 'Cancel',
              role: 'cancel'
            }
          ]
        });
        alert.present();
      });

      // this.enableLoc()

      this.events.subscribe('driver:profile', data => {
        this.local = data
        if (this.local) {
          this.local.image = this.local.image.startsWith("http") ? this.local.image : this.myservice.base_url + this.local.image;
        }
      })

      this.storage.get('driver_data').then(data=>{
        if(data!=null){
          this.local = data
          this.rootPage = 'HomePage'
          // this.oneSignal.getIds().then((id) => {
            // this.myservice.load_post({deviceid:id.userId,driverid:this.local.id},'updateDeviceid')
          // })
        }
        else{
          this.rootPage = 'LandingPage'
        }
      })
    });
  }

  openPage(page) {
    if (page == 'LandingPage'){
      this.storage.clear()
    }
    this.nav.setRoot(page);
  }

  initOnesignal() {
    this.oneSignal.startInit('ec007986-ae84-45fb-a770-f5be1e203acd', '151146703576');

    this.oneSignal.inFocusDisplaying(this.oneSignal.OSInFocusDisplayOption.InAppAlert);

    this.oneSignal.handleNotificationReceived().subscribe(() => {
      // do something when notification is received
    });

    this.oneSignal.handleNotificationOpened().subscribe(() => {
      // do something when a notification is opened
    });

    this.oneSignal.endInit();
  }

  enableLoc() {
    this.locationAccuracy.canRequest().then((canRequest: boolean) => {

      if (canRequest) {
        // the accuracy option will be ignored by iOS
        this.locationAccuracy.request(this.locationAccuracy.REQUEST_PRIORITY_HIGH_ACCURACY).then(
          () => console.log('Request successful'),
          error => console.log('Error requesting location permissions', error)
        );
      }

    });
  }

}
