import { Component } from '@angular/core';
import { IonicPage, NavController, NavParams } from 'ionic-angular';
import { Storage } from "@ionic/storage";
import { Myservice } from "../../providers/myservice";

@IonicPage()
@Component({
  selector: 'page-home',
  templateUrl: 'home.html',
})
export class HomePage {
tab:any;
upcoming:any;
completed:any;
baseurl = this.myservice.base_url

  constructor(public navCtrl: NavController, public navParams: NavParams, private storage:Storage, private myservice:Myservice) {
  }

  ionViewDidEnter(){
    this.storage.get('driver_data').then(data=>{
      if(data){
        this.myservice.load_post({id:data.id},'getMyRides').subscribe(response=>{
          if(response.status == 'success'){
            this.upcoming = response.data.upcoming
            this.completed = response.data.completed
            console.log(this.upcoming)
          }
        })
      }
    })
  }

  ionViewDidLoad() {
    console.log('ionViewDidLoad HomePage');
    this.tab = "active";
  }


tab_swap(type) {
    this.tab = type;
   }

  rideDetails(data){
    this.navCtrl.push('RidedetailsPage',{data:data})
  }
}
