import { Component } from '@angular/core';
import { IonicPage, NavController, NavParams } from 'ionic-angular';
import { Myservice } from "../../providers/myservice";
import { dateDataSortValue } from 'ionic-angular/umd/util/datetime-util';

@IonicPage()
@Component({
  selector: 'page-ridedetails',
  templateUrl: 'ridedetails.html',
})
export class RidedetailsPage {
  details = this.navParams.get('data')
  baseurl = this.myservice.base_url

  constructor(public navCtrl: NavController, public navParams: NavParams, private myservice: Myservice) {
   
  }

  ionViewDidLoad() {
    var tempf = this.details.pickup_area.split(',')
    this.details.from = tempf[0]
    this.details.fromAd = this.details.pickup_area
    this.details.timestamp = new Date(this.details.pickup_date + ' ' + this.details.pickup_time).getTime()

    var temp = this.details.drop_area.split(',')
    this.details.to = temp[0]
    this.details.toAd = this.details.drop_area
    console.log(this.details)
  }

  back(){
  	this.navCtrl.pop();
  }

  pick(){
    this.navCtrl.push('UserlocationPage',{ data: this.details})
  }

}
