import { BrowserModule } from '@angular/platform-browser';
import { ErrorHandler, NgModule } from '@angular/core';
import { IonicApp, IonicErrorHandler, IonicModule } from 'ionic-angular';
import { MyApp } from './app.component';
import { StatusBar } from '@ionic-native/status-bar';
import { SplashScreen } from '@ionic-native/splash-screen';

import { Myservice } from "../providers/myservice";
import { HttpModule } from "@angular/http";
import { IonicStorageModule } from '@ionic/storage';
import { OrderbyPipe } from '../providers/sort-pipe';
import { Toast } from '@ionic-native/toast';
import { Facebook } from '@ionic-native/facebook';
import { GooglePlus } from '@ionic-native/google-plus';
import { AngularFireModule } from 'angularfire2';
import { fireService } from '../providers/firebase.service'
import { AngularFireDatabase } from 'angularfire2/database';
import { Geolocation } from '@ionic-native/geolocation';
import { DatePicker } from '@ionic-native/date-picker';
import { LocationAccuracy } from '@ionic-native/location-accuracy';
import { SubjectService } from "../providers/subject.service";
import { dataService } from "../providers/common.service";
import { Network } from '@ionic-native/network';
import { CallNumber } from '@ionic-native/call-number';
import { OneSignal } from '@ionic-native/onesignal';
import { Gyroscope } from '@ionic-native/gyroscope';

export const firebaseConfig = {
  apiKey: "AIzaSyDLrbLd4RCCh86xuTVu7-cfJ28We_cG1sU",
  authDomain: "callmycab-205809.firebaseapp.com",
  databaseURL: "https://callmycab-205809.firebaseio.com",
  projectId: "callmycab-205809",
  storageBucket: "callmycab-205809.appspot.com",
  messagingSenderId: "151146703576"
};

@NgModule({
  declarations: [
    MyApp
  ],
  imports: [
    BrowserModule,
    IonicModule.forRoot(MyApp),
    HttpModule,
    IonicStorageModule.forRoot(),
    AngularFireModule.initializeApp(firebaseConfig),
  ],
  bootstrap: [IonicApp],
  entryComponents: [
    MyApp
  ],
  providers: [
    StatusBar,
    SplashScreen,
    {provide: ErrorHandler, useClass: IonicErrorHandler},
    Myservice,
    OrderbyPipe,
    Toast,
    Facebook,
    GooglePlus,
    fireService,
    AngularFireDatabase,
    Geolocation,
    DatePicker,
    LocationAccuracy,
    SubjectService,
    dataService,
    Network,
    CallNumber,
    OneSignal,
    Gyroscope
  ]
})
export class AppModule {}
