import { Component } from '@angular/core';
import { IonicPage, NavController, NavParams, ModalController } from 'ionic-angular';
import { Validators, FormBuilder, FormGroup } from "@angular/forms";
import { Myservice } from "../../providers/myservice";
import { dataService } from "../../providers/common.service";
import { Storage } from "@ionic/storage";
import { user } from "../../models/mymodel";

@IonicPage()
@Component({
  selector: 'page-addcoupon',
  templateUrl: 'addcoupon.html',
})
export class AddcouponPage {
  promoForm: FormGroup
  rate = this.navParams.get('rate').split(' to ');
  promo = { 'amount': Number(this.rate[0]), discount: '0' }
  local:user;
  promoBtn:boolean = false;
  booking:any;

  constructor(public navCtrl: NavController, public navParams: NavParams, public modalCtrl: ModalController, private formBuilder: FormBuilder, private myservice: Myservice, private data: dataService, private storage:Storage) {
    this.promoForm = this.formBuilder.group({
      promocode: [''],
      amount: [''],
      userid: ['']
    })
  }

  ionViewDidEnter() {
   this.booking = this.data.getbookingData()
    this.booking.promocode = null;
    this.storage.get('user_data').then(data=>{
      if(data){
        this.local = data;
      }
    })
  }

  goBack() {
    this.navCtrl.pop();
  }

  pay() {
    // let modal = this.modalCtrl.create('ConfirmridePage');
    // modal.present();
    this.data.setbookingData(this.booking)
    if (this.booking.type == 'later'){
      this.myservice.show_loader()
      this.navCtrl.push('ConfirmridePage');
    }
    else
      this.navCtrl.push('RidedetailPage');
    }

  checkCode() {
    this.myservice.show_loader();
    this.promoForm.controls['amount'].setValue(this.rate)
    this.promoForm.controls['userid'].setValue(this.local.id)
    this.myservice.load_post(this.promoForm.value, 'checkPromocode').subscribe(response => {
      this.myservice.hide_loader()
      if (response.status == 'success') {
        this.promo = response.data
        this.promoBtn = true;
        this.booking.promocode = this.promoForm.value.promocode
        this.booking.discount = this.promo.discount
      }
      else {
        this.myservice.show_alert('Error', response.message)
      }
    })
  }

}
