import { Component } from '@angular/core';
import { IonicPage, NavController, NavParams, ViewController, ModalController, Platform } from 'ionic-angular';
import { Myservice } from "../../providers/myservice";
import { dataService } from "../../providers/common.service";
import { Storage } from "@ionic/storage";
import { user } from "../../models/mymodel";

@IonicPage()
@Component({
  selector: 'page-confirmride',
  templateUrl: 'confirmride.html',
})
export class ConfirmridePage {
  type = this.navParams.get('type')
  local: user
  book: any
  public unregisterBackButtonAction: any;

  constructor(public navCtrl: NavController, public navParams: NavParams, public viewCtrl: ViewController, public modalCtrl: ModalController, private myservice: Myservice, private data: dataService, private storage: Storage, public platform: Platform) {
  }

  ionViewDidEnter() {
    this.storage.get('user_data').then(data => {
      if (data) {
        this.local = data;

        this.book = this.data.getbookingData()
        console.log(this.book)

        var bdata = { 'book_date': this.book.date, 'drop_area': this.book.dropArea, 'pickup_area': this.book.pickArea, 'taxi_type': this.book.carDetails.car_type, 'amount': '', 'km': '', 'promocode': this.book.promocode, 'token': this.local.token, 'userid': this.local.id, 'type': 'later', 'drivers': [], 'discount': this.book.discount ? this.book.discount : 0, 'pickup_latlng': this.book.pickLat + ',' + this.book.pickLng, 'drop_latlng': this.book.dropLat + ',' + this.book.dropLng}

        this.myservice.load_post(bdata, 'book_cab').subscribe(response => {
          this.myservice.hide_loader()
          if (response.status == 'success') {
            this.initializeBackButtonCustomHandler();
          }
          else {
            this.myservice.show_alert('Failed', 'Please try again')
            this.navCtrl.pop()
          }
        })

      }
    })
  }

  public initializeBackButtonCustomHandler(): void {
    this.unregisterBackButtonAction = this.platform.registerBackButtonAction(() => {
      // this.customHandleBackButton();
    }, 10);
  }

  ionViewWillLeave() {
    this.unregisterBackButtonAction && this.unregisterBackButtonAction();
  }

  dismiss() {
    this.navCtrl.setRoot('HomePage')
  }

  home() {
    this.navCtrl.setRoot('HomePage')
  }

}
