import { Component } from '@angular/core';
import { IonicPage, NavController, NavParams } from 'ionic-angular';
import { FormGroup, Validators, FormBuilder } from '@angular/forms'
import { Myservice } from '../../providers/myservice'

@IonicPage()
@Component({
  selector: 'page-forgot',
  templateUrl: 'forgot.html',
})
export class ForgotPage {

  forgotForm: FormGroup

  constructor(public navCtrl: NavController, public navParams: NavParams, private formbuilder: FormBuilder, private myservice: Myservice) {

    this.forgotForm = this.formbuilder.group({
      email: ['', Validators.compose([Validators.required, Validators.pattern("[a-zA-Z0-9.-_]{1,}@[a-zA-Z.-]{2,}[.]{1}[a-zA-Z]{2,}")])],
      from:['user']
    })
  }

  forgot() {
    this.myservice.show_loader()
    this.myservice.load_post(this.forgotForm.value, 'Forget_password').subscribe(response => {
      this.myservice.hide_loader()
      if (response.status == 'success') {
        this.myservice.show_alert('', response.message)
        this.navCtrl.pop();
      }
      else {
        this.myservice.show_alert('', response.message)
      }
    })
  }


}
