import { Component,ViewChild } from '@angular/core';
import { IonicPage, NavController, NavParams,Content,Slides } from 'ionic-angular';
import { Myservice } from "../../providers/myservice";
import { Storage } from "@ionic/storage";
import { user } from "../../models/mymodel";

@IonicPage()
@Component({
  selector: 'page-mytrips',
  templateUrl: 'mytrips.html',
})
export class MytripsPage {

  showPrev:any;
  showNext:any;
  currentIndex:any;
  slidertab:any;
  local:user
  allTrips:any;
  upTrips:any;
  compTrips:any;
  trips:any;

  @ViewChild(Content) content: Content;
  @ViewChild('mySlider') slider: Slides;

  constructor(public navCtrl: NavController, public navParams: NavParams, private myservice: Myservice, private storage: Storage) {

    let id = 0;
    this.slidertab = id;
    setTimeout(() => {
    this.goToSlide(id);
    }, 500)
    this.slidertab = 0;

  }

  ionViewDidEnter() {
    this.storage.get('user_data').then(data => {
      if (data) {
        this.local = data;
        this.myservice.load_post({ 'token': this.local.token }, 'myTrips').subscribe(response => {
          this.myservice.hide_loader()
          if (response.status == 'success') {
            this.trips = response.all
            console.log(this.trips)
          }
          else {
            this.myservice.show_alert('Failed', 'Please try again')
          }
        })

      }
    })
  }

  goToSlide(id) {
  this.slider.slideTo(id, 500);
  }

  slideChanged() {
  let currentIndex = this.slider.getActiveIndex();
  this.slidertab = currentIndex;
  }

  open_page(page,index){
    this.navCtrl.push(page,{data:this.trips[index]});
  }

}
