import { Component, NgZone } from '@angular/core';
import { IonicPage, NavController, NavParams, Platform } from 'ionic-angular';
import { dataService } from "../../providers/common.service";
import { Myservice } from "../../providers/myservice";
import { Storage } from "@ionic/storage";
import { user } from "../../models/mymodel";
import * as firebase from 'firebase';

declare var google;

@IonicPage()
@Component({
  selector: 'page-payment',
  templateUrl: 'payment.html',
})
export class PaymentPage {

  book: any;
  geocoder: any;
  loc = { from: '', to: '', fromAd: '', toAd: '' }
  local: user
  public unregisterBackButtonAction: any;
  driver: any;
  ride: any;

  constructor(public navCtrl: NavController, public navParams: NavParams, private data: dataService, private zone: NgZone, private myservice: Myservice, private storage: Storage, public platform: Platform) {
  }

  ionViewDidEnter() {
    this.myservice.hide_loader();
    this.initializeBackButtonCustomHandler();
    this.storage.get('user_data').then(data => {
      if (data) {
        this.local = data
        this.book = this.data.getbookingData()
        console.log(this.book)

        this.driver = this.data.getdriverData()
        console.log(this.driver)


        this.geocoder = new google.maps.Geocoder();
        for (let i = 0; i < 2; i++) {
          if (i == 0) {
            var lat = this.book.pickLat
            var lng = this.book.pickLng
          }
          else {
            var lat = this.book.dropLat
            var lng = this.book.dropLng
          }
          var latlng = new google.maps.LatLng(lat, lng);
          var This = this;
          This.geocoder.geocode({ 'latLng': latlng }, function (results, status) {
            if (status == google.maps.GeocoderStatus.OK) {
              if (results[0]) {
                if (i == 0) {
                  var temp = This.book.pickArea.split(',')
                  This.loc.from = temp[0]
                  This.loc.fromAd = results[0].formatted_address
                }
                else {
                  var temp = This.book.dropArea.split(',')
                  This.loc.to = temp[0]
                  This.loc.toAd = results[0].formatted_address
                  This.zone.run(() => { });
                }
              }
            }
            else {
              console.log("Geocoder failed due to: " + status);
            }
          });
        }
      }

      this.myservice.load_post({ bookingId: this.book.bookingId }, 'getRideDetails').subscribe(resp => {
        if (resp.status == 'success') {
          this.ride = resp.data
          this.ride.amount = Number(this.ride.amount)
          if (this.ride.discount) {
            if (this.ride.discount.slice(-1) == '%') {
              var disc_amt = this.ride.discount.slice(0, -1)
              this.ride.discount = Number(this.ride.amount) * (disc_amt / 100)
            }
          }
          else {
            this.ride.discount = 0;
          }
          console.log(this.ride)
          console.log(this.loc)
        }
      })
    })
  }

  public initializeBackButtonCustomHandler(): void {
    this.unregisterBackButtonAction = this.platform.registerBackButtonAction(() => {
      // this.customHandleBackButton();
    }, 10);
  }

  ionViewWillLeave() {
    this.unregisterBackButtonAction && this.unregisterBackButtonAction();
  }

  close() {
    this.navCtrl.push('RattingPage', { driver: this.driver })
  }

}
