import { Component } from '@angular/core';
import { IonicPage, NavController, NavParams,ViewController } from 'ionic-angular';
import { Myservice } from "../../providers/myservice";
import { Storage } from "@ionic/storage";
import { user } from "../../models/mymodel";
import { dataService } from "../../providers/common.service";
import { Toast } from "@ionic-native/toast";

@IonicPage()
@Component({
  selector: 'page-ratting',
  templateUrl: 'ratting.html',
})
export class RattingPage {
  driver = this.navParams.get('driver')
  rate:number;
  local:user;

  constructor(public navCtrl: NavController, public navParams: NavParams,public viewCtrl:ViewController, private myservice: Myservice, private storage:Storage, private comData:dataService, private toast:Toast) {
  }

  ionViewDidEnter() {
    this.storage.get('user_data').then(data=>{
      if(data){
        this.local = data
        
      }
    })
  }
  
  dismiss()
  {
    this.navCtrl.setRoot('HomePage')
  }

  submit(){
    if(this.rate!=undefined && this.rate){
      this.myservice.show_loader();
      var book = this.comData.getbookingData()
      var data = { 'rating': this.rate, 'username': this.local.id, 'driver_id': this.driver.driverId, 'booking_id': book.bookingid }
      console.log(data)

      this.myservice.load_post(data, 'setRating').subscribe(response => {
        this.myservice.hide_loader()
        if (response.status == 'success') {
          this.navCtrl.setRoot('HomePage')

          this.toast.show(response.message, '2000', 'center').subscribe(
            toast => {
              console.log(toast);
            });
        }
        else {
          this.myservice.show_alert('', response.message)
        }
      })
    }
  }

}
