import { Component,NgZone } from '@angular/core';
import { IonicPage, NavController, NavParams,ViewController,ModalController } from 'ionic-angular';
import { dataService } from "../../providers/common.service";
import { Myservice } from "../../providers/myservice";

declare var google;

@IonicPage()
@Component({
  selector: 'page-ridenow',
  templateUrl: 'ridenow.html',
})
export class RidenowPage {
  details:any;
  rates:any;
  totRate:string;

  constructor(public navCtrl: NavController, public navParams: NavParams, public viewCtrl: ViewController, public modalCtrl: ModalController, private data: dataService, private myservice:Myservice,private zone:NgZone) {
  }

  ionViewDidEnter() {
   this.details = this.data.getbookingData()
  //  console.log(this.details)
    this.myservice.load_post({ time: this.details.date, type: this.details.carDetails.car_type }, 'getRate').subscribe(response=>{
      if(response.status == 'success'){
        this.rates = response.data
      }
    })

    var origin = new google.maps.LatLng(this.details.pickLat, this.details.pickLng)
    var destination = new google.maps.LatLng(this.details.dropLat, this.details.dropLng)
    var service = new google.maps.DistanceMatrixService();
    
    var This = this
    service.getDistanceMatrix(
      {
        origins: [origin],
        destinations: [destination],
        travelMode: google.maps.DirectionsTravelMode.DRIVING,
        avoidHighways: true,
        avoidTolls: true,
      }, function (response, status) {
        if (response.originAddresses[0] != '') {
          console.log(response.rows[0].elements[0])
          This.myservice.load_post({ gdata: response.rows[0].elements[0], car: This.details.carDetails},'getEstimateRate').subscribe(response=>{
            if(response.status == 'success'){
              This.totRate = response.data
              This.zone.run(() => { });
            }
          })
        }
      });
  }

  dismiss()
  {
    this.viewCtrl.dismiss();
  }

  addcoupon() {
    this.viewCtrl.dismiss(this.totRate);
    // this.navCtrl.push('AddcouponPage',{rate:this.totRate});
      // let modal = this.modalCtrl.create('AddcouponPage');
      // modal.present();
    }
	
	ratecard() {
    this.data.setrateData(this.rates)
      let modal = this.modalCtrl.create('RatecardPage',);
      modal.present();
    }

}
