import { Component } from '@angular/core';
import { IonicPage, NavController, NavParams, ViewController, ModalController} from 'ionic-angular';
import { Myservice } from "../../providers/myservice";
import { cartype } from "../../models/mymodel";
import { DatePicker } from '@ionic-native/date-picker';
import { dataService } from "../../providers/common.service";

@IonicPage()
@Component({
  selector: 'page-ridepop',
  templateUrl: 'ridepop.html',
})
export class RidepopPage {
  carTypes:Array<cartype>
  carIndex:number = 0;
  locData:any;

  constructor(public navCtrl: NavController, public navParams: NavParams, public viewCtrl: ViewController, private myservice: Myservice, private datePicker: DatePicker, private data: dataService, public modalCtrl: ModalController) {
  }

  ionViewDidEnter() {
    this.locData = this.data.getbookingData()
    console.log(this.locData)
    this.myservice.show_loader()
    this.myservice.load_post({},'getCabDetails').subscribe(response=>{
      this.myservice.hide_loader()
      if(response.status == 'success'){
        this.carTypes = response.data
      }
      else{
        this.myservice.show_alert('Failed',response.message)
      }
    })
  }

  carClick(index, $event){
    this.carIndex = index;
    //event.target.classList.toggle('act');
  }

  bookLater(){
    this.datePicker.show({
      date: new Date(),
      mode: 'datetime',
      minDate: new Date(),
      allowOldDates:false,
      androidTheme: this.datePicker.ANDROID_THEMES.THEME_HOLO_DARK
    }).then(
      date =>{
        if (date < new Date()){
          this.myservice.show_alert('Error','Please select a valid date')
        }
        else{
          console.log('1', date)
          this.locData = this.data.getbookingData()
          this.locData.date = date//new Date()
          this.locData.carDetails = this.carTypes[this.carIndex]
          this.locData.type = 'later'
          this.data.setbookingData(this.locData);
          this.viewCtrl.dismiss('later');

        }
      },
      err => console.log('Error occurred while getting date: ', err)
    );
  }

  bookNow(){
    this.locData = this.data.getbookingData()
    this.locData.date = new Date()
    this.locData.carDetails = this.carTypes[this.carIndex]
    this.locData.type = 'ride'
    this.data.setbookingData(this.locData);
    this.viewCtrl.dismiss('ride');
  }

  dismiss()
  {
    this.viewCtrl.dismiss();
  }

}
