import { Component } from '@angular/core';
import { IonicPage, NavController, NavParams,ViewController } from 'ionic-angular';
import { Myservice } from "../../providers/myservice";
import { Storage } from "@ionic/storage";
import { user, search } from "../../models/mymodel";
@IonicPage()
@Component({
  selector: 'page-searchride',
  templateUrl: 'searchride.html',
})
export class SearchridePage {
  local:user
  searches:Array<search>
  searchText:string;

  constructor(public navCtrl: NavController, public navParams: NavParams,public viewCtrl: ViewController, private myservice:Myservice, private storage: Storage) {
  }

  ionViewDidEnter() {
    this.myservice.show_loader()
    this.storage.get('user_data').then(data=>{
      if(data){
        this.local = data
        this.myservice.load_post({userid:this.local.id},'getSearches').subscribe(response=>{
          this.myservice.hide_loader()
          if(response.status == 'success'){
            this.searches = response.data
          }
        })
      }
    })
  }

  setDirection(data){
    this.viewCtrl.dismiss(data);
  }
  
  dismiss()
  {
    this.viewCtrl.dismiss();
  }

}
