import { Component } from '@angular/core';
import { IonicPage, NavController, NavParams } from 'ionic-angular';
import { Myservice } from "../../providers/myservice";
import { Storage } from "@ionic/storage";
import { user } from "../../models/mymodel";
import { Toast } from "@ionic-native/toast";
import { CallNumber } from '@ionic-native/call-number';

@IonicPage()
@Component({
  selector: 'page-tripdetails',
  templateUrl: 'tripdetails.html',
})
export class TripdetailsPage {
  details = this.navParams.get('data')
  local:user

  constructor(public navCtrl: NavController, public navParams: NavParams, private myservice: Myservice, private storage: Storage, private toast: Toast, private callNumber: CallNumber) {
  }

  ionViewDidEnter() {
    this.storage.get('user_data').then(data=>{
      if(data){
        this.local = data
      }
    })
    console.log(this.details);
  }

  back(){
    this.navCtrl.pop();
  }

  rating(event){
    if (Number(event.srcElement.value)){
      this.myservice.show_loader()
      var data = { 'rating': Number(event.srcElement.value), 'username': this.local.id, 'driver_id': this.details.assigned_for, 'booking_id': this.details.bookingid}
      this.myservice.load_post(data,'setRating').subscribe(response=>{
        this.myservice.hide_loader()
        if(response.status=='success'){
          this.details.rating = Number(event.srcElement.value)
          this.toast.show(response.message, '2000', 'center').subscribe(
            toast => {
              console.log(toast);
            });
        }
        else{
          this.myservice.show_alert('',response.message)
        }
      })
    }
  }

  call(){
    this.callNumber.callNumber(this.details.phone, true)
      .then(res => console.log('Launched dialer!', res))
      .catch(err => console.log('Error launching dialer', err));
  }

  cancel(){
    this.myservice.show_loader()
    this.myservice.load_post({id:this.details.bookingid},'cancelRide').subscribe(response=>{
      this.myservice.hide_loader()
      if(response.status == 'success'){
        this.details.status = 'Cancelled'
        this.toast.show(response.message, '2000', 'center').subscribe(
          toast => {
            console.log(toast);
          });
      }
      else{
        this.myservice.show_alert('',response.message)
      }
    })
  }

}
