import { NgModule } from '@angular/core';
import { PreloadAllModules, RouterModule, Routes } from '@angular/router';

const routes: Routes = [
  {
    path: '',
    redirectTo: 'login',
    pathMatch: 'full'
  },
  {
    path: 'home',
    loadChildren: './home/home.module#HomePageModule'
  },
  {
    path: 'list',
    loadChildren: './list/list.module#ListPageModule'
  },
  { 
    path: 'login',
    loadChildren: './login/login.module#LoginPageModule'
  },
  { 
    path: 'signup',
    loadChildren: './signup/signup.module#SignupPageModule' 
  },
  { 
    path: 'details/:id',
    loadChildren: './details/details.module#DetailsPageModule'
  },
  { path: 'medicalauthorization/:id', 
  loadChildren: './medicalauthorization/medicalauthorization.module#MedicalauthorizationPageModule'
 },
  { path: 'studentsprofile/:id', loadChildren: './studentsprofile/studentsprofile.module#StudentsprofilePageModule' },
  { path: 'healthcareforum/:id', loadChildren: './healthcareforum/healthcareforum.module#HealthcareforumPageModule' },
  { path: 'treatmentauthorization/:id', loadChildren: './treatmentauthorization/treatmentauthorization.module#TreatmentauthorizationPageModule' },
  { path: 'medicationtracking/:id', loadChildren: './medicationtracking/medicationtracking.module#MedicationtrackingPageModule' },
  { path: 'treatmenttrackings/:id', loadChildren: './treatmenttrackings/treatmenttrackings.module#TreatmenttrackingsPageModule' },
  { path: 'screenings/:id', loadChildren: './screenings/screenings.module#ScreeningsPageModule' },
  { path: 'chartvisits/:id', loadChildren: './chartvisits/chartvisits.module#ChartvisitsPageModule' },
  { path: 'immunizations/:id', loadChildren: './immunizations/immunizations.module#ImmunizationsPageModule' },
  { path: 'medicalhistory/:id', loadChildren: './medicalhistory/medicalhistory.module#MedicalhistoryPageModule' },
  { path: 'healthhistory/:id', loadChildren: './healthhistory/healthhistory.module#HealthhistoryPageModule' }


];

@NgModule({
  imports: [
    RouterModule.forRoot(routes, { preloadingStrategy: PreloadAllModules })
  ],
  exports: [RouterModule]
})
export class AppRoutingModule {}
