import {Component,OnInit, ElementRef, NgZone, ViewChild} from '@angular/core';
import { trigger, transition, animate, style } from '@angular/animations';
import { Router, ActivatedRoute } from '@angular/router';
import { MyserviceService} from '../myservice.service'


@Component({
  selector: 'app-details',
  templateUrl: './details.page.html',
  styleUrls: ['./details.page.scss'],
  animations: [
    trigger('slideInOut', [
      transition(':enter', [
        style({transform: 'translateY(-100%)'}),
        animate('100ms ease-in', style({transform: 'translateY(0%)'}))
      ]),
      transition(':leave', [
        animate('100ms ease-out', style({transform: 'translateY(-100%)'}))
      ])
    ])
  ]
})
export class DetailsPage implements OnInit {
  stud1:boolean;
  stud2:boolean;
  stud3:boolean;
  navCtrl: any;
  isToggle = false;
  id: any;
  student_details:any;
  constructor(private route: ActivatedRoute ,private myservice:MyserviceService,private router: Router) {
   
   }

  ngOnInit() {
    this.id = this.route.snapshot.paramMap.get('id');
    console.log(this.id);
    this.get_StudentDetails();
  }
  get_StudentDetails() {
    var This= this;
  this.myservice.presentLoader();
  console.log('Id',this.id)
    this.myservice.load_get('student_details/id/'+this.id).subscribe(resp =>
      {
        console.log(resp);
        
        This.myservice.dismissLoader();
        this.student_details=resp;
       
      })
   
  }
  goToPage(path,data=null){
    this.router.navigateByUrl('/'+path+'/'+this.id);
    document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
   

  popToggle(){
    this.isToggle = !this.isToggle;
  }
  getimage() {
   
    console.log('Student number',this.student_details.student_no)
      if(this.student_details.student_no = 1)
      {
        console.log('check')
        var img1 ="../../assets/imgs/asset_img1.png";
        return img1;
      }
      if(this.student_details.student_id = 2) {
        var img2 = "../../assets/imgs/asset_img2.png";
        return img2;
      }
      if(this.student_details.student_id = 3) {
        var img3 = "../../assets/imgs/asset_img3.png";
        return img3;
      }
   }
}
