  import {Component,OnInit, ElementRef, NgZone, ViewChild} from '@angular/core';
import { trigger, transition, animate, style } from '@angular/animations';
import { Router,ActivatedRoute } from '@angular/router';
import {Validators, FormBuilder, FormGroup, FormControl } from '@angular/forms';
import {MyserviceService} from '../myservice.service'


@Component({
  selector: 'app-login',
  templateUrl: './login.page.html',
  styleUrls: ['./login.page.scss'],
  animations: [
    trigger('slideInOut', [
      transition(':enter', [
        style({transform: 'translateY(100%)'}),
        animate('300ms ease-in', style({transform: 'translateY(0%)'}))
      ]),
      transition(':leave', [
        animate('300ms ease-out', style({transform: 'translateY(100%)'}))
      ])
    ])
  ]
})
export class LoginPage implements OnInit {
  private LoginForm : FormGroup;
  private signupForm : FormGroup;
  isShow = false;

  constructor(
    public myservice:MyserviceService,
    private router: Router,
    private route: ActivatedRoute,
    private formBuilder: FormBuilder,
    
    ) { 
      this.LoginForm = this.formBuilder.group({ 
				email:  ['', Validators.compose([Validators.pattern("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$"), Validators.required])],
				password: ['', Validators.compose([Validators.required, Validators.minLength(6)]) ] 
      });
      this.signupForm = this.formBuilder.group({ 
        user_name:['',Validators.required],
				email:  ['', Validators.compose([Validators.pattern("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$"), Validators.required])],
        password: ['', Validators.compose([Validators.required, Validators.minLength(6)]) ] ,
        mobile_no:['',Validators.compose([Validators.required, Validators.minLength(10)])],
        gender :['',Validators.required],


         
			});
    }

  ngOnInit() {
  }

  istoggle(){
    this.isShow = !this.isShow;
  }

  goToPage(path,data=null){
    this.router.navigateByUrl(path,{queryParams:data});
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }
  login()
  {
    var This= this
    var data = null
    console.log(this.LoginForm.value);
    this.myservice.presentLoader();
    var obj = {'value': this.LoginForm.value }
    this.myservice.load_post(obj,'login').subscribe(resp =>{
      This.myservice.dismissLoader();
        console.log(resp.username);
       if(resp.username === this.LoginForm.value['email'] && resp.password === this.LoginForm.value['password']){
           this.myservice.presentToast('Login Success');
           this.gotoPage();
           this.LoginForm.reset();
          }
        else {
          this.myservice.presentToast('Invalid credentials');
          this.LoginForm.reset();
        }
      });
    }
  
  user_signup()
  {
  if(this.signupForm.valid) {
    var data =null;
  this.myservice.presentToast('Your account has been created successfully');
  this.isShow = !this.isShow;
 }
}
gotoPage() {
  var data = null;
  var This= this;
  setTimeout( () => {
    This.router.navigateByUrl('home',{queryParams:data,replaceUrl: true});
    document.body.scrollTop = document.documentElement.scrollTop = 0;
}, 500);
  
}
}
