import {Component,OnInit, ElementRef, NgZone, ViewChild} from '@angular/core';
import { trigger, transition, animate, style } from '@angular/animations';
import {MyserviceService} from '../myservice.service';
import { Router, ActivatedRoute } from '@angular/router';
@Component({
 selector: 'app-medicalauthorization',
 templateUrl: './medicalauthorization.page.html',
 styleUrls: ['./medicalauthorization.page.scss']
})
export class MedicalauthorizationPage implements OnInit {
 id:any;
 shownGroup = null;
 medicalresp:any

 constructor(public myservice:MyserviceService,private router: Router,private route: ActivatedRoute) {
 this.shownGroup = 0;
 }

 ngOnInit() {
  this.id = this.route.snapshot.paramMap.get('id');
  console.log(this.id);
  this.get_medical_data();
 }

 isGroupShown(group) {
 return this.shownGroup === group;
 }

 toggleGroup(group) {
 if (this.isGroupShown(group)) {
 this.shownGroup = null;
 } else {
 this.shownGroup = group;
 }
 }
 get_medical_data(){
   this.myservice.presentLoader();
   this.myservice.load_get('get_medicalauthorization/id/'+this.id).subscribe(resp =>{
     this.myservice.dismissLoader();
     this.medicalresp = this.myservice.ObjArray(resp.data);
     console.log('Medical', this.medicalresp)
   });
 }


}
