import { Injectable } from '@angular/core';
import { Component } from '@angular/core';
import { Http, Headers, RequestOptions } from '@angular/http';
import { map } from 'rxjs/operators';
import { LoadingController ,ToastController } from '@ionic/angular';
import {Observable,of, from } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class MyserviceService {
  webservice_url =' https://demo8587560.mockable.io/';
  post_url : any;
  loading:any;
  currentLoading:any
  constructor(
    public http: Http,
    public loadingController: LoadingController,
    public toastController: ToastController
    ) { }

    load_post(post_data, fn_name) {
      var post_url = this.webservice_url + fn_name;
      post_data = JSON.stringify(post_data);
      // let headers = new Headers({
      //   'Content-Type' : 'application/json'
      // });
      // let options = new RequestOptions({ headers: headers });
      return this.http.post(post_url, post_data).pipe(map(res => res.json()));
    }
    
      load_get(fn_name) {
        this.post_url = this.webservice_url + fn_name;
        return this.http.get(`${this.post_url}`).pipe(map(res => res.json()));
      } 
    
      async presentLoader() {
        if (this.currentLoading != null) {
            this.currentLoading.dismiss();
        }

        this.currentLoading = await this.loadingController.create({
           
            message: 'Loading...'
        });

        return await this.currentLoading.present();
    }

    async dismissLoader() {
           await this.loadingController.dismiss();
            this.currentLoading = null;
           console.log('Dismis loader')
       // return;
      }
    async presentToast(message) {
      const toast = await this.toastController.create({
        message: message,
        duration: 2000
      });
      toast.present();
    }
    ObjArray(data: any) {
      if (data instanceof Array !== true) {
        if (data !== undefined) {
          return new Array(data);
        } else {
          return undefined;
        }
      } else {
        return data;
      }
    }
}
