<div class="content-wrapper">
  <section class="content-header">
    <h1>
       <?= $pTitle ?>
        <small><?= $pDescription ?></small>
    </h1>
    <ol class="breadcrumb">
     <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
     <li><?= $menu ?></li>
     <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php 
        $url = (!isset($category_id)||empty($category_id))
                  ?'Category/createCategory':'Category/updateCategory/'.$category_id;

        if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
            <button class="close" data-dismiss="alert" type="button">×</button>
            <?= $flashdata['message'] ?>
          </div>
        <?php } ?>
      </div>
      <div class="col-md-12">
        <div class="box box-warning">
          <div class="box-body">
            <form role="form" action="<?= base_url($url) ?>" method="post" 
              class="validate" data-parsley-validate="" enctype="multipart/form-data">
              <div class="col-md-12">
                <div class="col-md-3">
                  <div class="form-group">
                    <label>Category Name (English)</label>
                    <input type="text" class="form-control required" data-parsley-trigger="change"
                    data-parsley-minlength="2" data-parsley-pattern="^[a-zA-Z0-9\ . _ - ' \/]+$" 
                    name="category" required="" value="<?= (isset($categoryData->category))?$categoryData->category:'' ?>" placeholder="Category Name">
                    <span class="glyphicon form-control-feedback"></span>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label>Category Name (Arabic)</label>
                    <input type="text" class="form-control required" data-parsley-trigger="change"
                    data-parsley-minlength="2" name="category_ar" required placeholder="Category Name"
                    value="<?= (isset($categoryData->category_ar))?$categoryData->category_ar:''?>">
                    <span class="glyphicon form-control-feedback"></span>
                  </div>
                </div>

                <div class="col-md-6">
                  <div class="form-group">
                    <label>Category Icon Web</label>
                    <div class="col-md-12" style="padding-bottom:10px;">
                      <div class="col-md-3">
                        <img id="image_id" src="<?= (isset($categoryData->category_image))?base_url($categoryData->category_image):'' ?>" onerror="this.src='<?=base_url("assets/images/user_avatar.jpg")?>';" height="75" width="75" />
                      </div>
                      <div class="col-md-9" style="padding-top: 25px;">
                        <input name="category_image" type="file" accept="image/*" onchange="setImg(this,'image_id');" />
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-md-12">
                <div class="col-md-6">
                  <div class="form-group">
                    <label>Category Description</label>
                    <textarea type="text" class="form-control required" data-parsley-trigger="change"
                    data-parsley-minlength="2" name="category_description" required placeholder="Category Description" style="height:76px;"><?= (isset($categoryData->category_description))?$categoryData->category_description:'' ?></textarea>
                    <span class="glyphicon form-control-feedback"></span>
                  </div>
                </div>

                <div class="col-md-6">
                  <div class="form-group">
                    <label>Category Icon Mobile</label>
                    <div class="col-md-12" style="padding-bottom:10px;">
                      <div class="col-md-3">
                        <img id="category_image_mob" src="<?= (isset($categoryData->category_image_mob))?base_url($categoryData->category_image_mob):'' ?>" onerror="this.src='<?=base_url("assets/images/user_avatar.jpg")?>';" height="75" width="75" />
                      </div>
                      <div class="col-md-9" style="padding-top: 25px;">
                        <input name="category_image_mob" type="file" accept="image/*" onchange="setImg(this,'category_image_mob');" />
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-12">      
                <div class="box-footer textCenterAlign">
                  <button type="submit" class="btn btn-primary">Submit</button>
                  <a href="<?= base_url('Category/listCategory') ?>" class="btn btn-primary">Cancel</a>
                </div>        
              </div>        
            </form>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>