<?php 

class Validation_hotel_model extends CI_Model {
	public $validation_array = array(
		'get_hotel_city_list'=>array(),
		'hotel_search'=>array(
			'auth_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'User id is null or empty'
				)
			)
		),
		'get_specific_hotel_content'=>array(
			'auth_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'User id is null or empty'
				)
			),
			'hotelId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Hotel Id is null or empty'
				)
			),
			'productId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Product Id is null or empty'
				)
			),
			'sessionId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Session Id is null or empty'
				)
			),
			'trackingId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Tracking Id is null or empty'
				)
			)
		),
		'get_room_rates'=>array(
			'auth_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'User id is null or empty'
				)
			),
			'TraceId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Trace Id is null or empty'
				)
			),
			'propertyid' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Property Id is null or empty'
				)
			),
			'trackingId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Tracking Id is null or empty'
				)
			),
			'sessionId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Session Id is null or empty'
				)
			),
			'productId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Product Id is null or empty'
				)
			),
			'TokenId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Token Id is null or empty'
				)
			),
			'resultindex' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Result Index Field is null or empty'
				)
			),
			'hotelcode' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Hotel Code is null or empty'
				)
			),
		),
		'get_rate_rules'=>array(
			'auth_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'User Id is null or empty'
				)
			),
			'TokenId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Token Id is null or empty'
				)
			),
			'TraceId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Trace Id is null or empty'
				)
			),
			'allocationDetails' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Allocation Details is null or empty'
				)
			),
			'booking_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Booking Token is null or empty'
				)
			),
			'hotel_name' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Hotel Name is null or empty'
				)
			),
			'hotelcode' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Hotel Code is null or empty'
				)
			),
			'infosource' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Infosource Field is null or empty'
				)
			),
			'meal_code' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Meal Code Field is null or empty'
				)
			),
			'productId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Product Id is null or empty'
				)
			),
			'propertyid' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Property Id is null or empty'
				)
			),
			'rate_basis_id' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Rate Basis Id is null or empty'
				)
			),
			'resultindex' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Result Index field is null or empty'
				)
			),
			'room_code' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Room Code is null or empty'
				)
			),
			'roomType_runno' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Room Type Runno Field is null or empty'
				)
			),
			'sessionId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Session Id is null or empty'
				)
			),
			'trackingId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Tracking Id is null or empty'
				)
			),
			'boardCode' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Board Code Field is null or empty'
				)
			),
		),
		'hotel_book'=>array(
			'auth_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'User Id is null or empty'
				)
			),
			'TokenId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Token Id is null or empty'
				)
			),
			'TraceId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Trace Id is null or empty'
				)
			),
			'changedOccupancy' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Changed Occupancy Field is null or empty'
				)
			),
			'extrabeds' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Extrabeds Field is null or empty'
				)
			),
			'guests_details' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Guest Details field is null or empty'
				)
			),
			'hotelcode' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Hotel Code is null or empty'
				)
			),
			'refcode' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Refcode Field is null or empty'
				)
			),
			'prebookingtoken' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Pre Booking Token is null or empty'
				)
			),
			'productId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Product Id is null or empty'
				)
			),
			'propertyid' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Property Id is null or empty'
				)
			),
			'resultindex' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Result Index field is null or empty'
				)
			),
			'sessionId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Session Id is null or empty'
				)
			),
			'trackingId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Tracking Id is null or empty'
				)
			),
		),
		'trawex_cancel_booking'=>array(
			'auth_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'User Id is null or empty'
				)
			),
			'trackingId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Tracking Id is null or empty'
				)
			),
			'productId' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Product Id is null or empty'
				)
			),
			'supplierConfirmationNum' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Supplier Confirmation Number is null or empty'
				)
			),
			'reference' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Reference Id is null or empty'
				)
			),
		),
	);

	public function validation_check($method_name, $parms) {
 		$state = 0;
 		$rules = $this->validation_array[$method_name]; 		
 		$error_key = '';
 		foreach ($rules as $key => $value) {
 			foreach ($value as $keys => $values) {
 				switch ($keys) {
 						case 'required':
 							if(!isset($parms[$key]) || $parms[$key]=='' || $parms[$key]== null){
 								$state = 1;
 								$error_key = $values;
 							} 
 							break;
 						case 'email':
 							if (isset($parms[$key]) && !filter_var($parms[$key], FILTER_VALIDATE_EMAIL)) {
	  							$state = 1;
 								$error_key = $values; 
							} 
 							break;
 						case 'phone':
 							if(isset($parms[$key])){
 							$phone = preg_replace('/[^0-9]/', '', $parms[$key]);
	 							/*if (strlen($phone) !== 10) {
		  							$state = 1;
	 								$error_key = $values; 
								} */
							} 
 							break;


 						
 						default:
 							# code...
 							break;
 					}
 					if($state==1){
 						break;
 					}
 			}
 			if($state==1){
 				break;
 			}
 		}
 		return array('state'=>$state,'response'=>$error_key);
 	} 	
}
?>
