<?php 

class Validation_flight_model extends CI_Model {
	public $validation_array = array(
		'flight_authenticate'=>array(
			'auth_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'User Id is null or empty'
				)
			)
		),
		'flight_availability_search'=>array(
			'auth_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'User Id is null or empty'
				)
			),
			'journey_type' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Journey Type is null or empty'
				)
			),
			'airport_from_code' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Airport From Code is null or empty'
				)
			),
			'airport_to_code' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'airport To Code is null or empty'
				)
			),
			'departure_date' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Departure Date is null or empty'
				)
			),
			'adult_flight' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Adult Flight is null or empty'
				)
			),
			'child_flight' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Child Flight is null or empty'
				)
			),
			'infant_flight' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Infant Flight is null or empty'
				)
			),
			'class' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Class Field is null or empty'
				)
			),
			'target' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Target Field is null or empty'
				)
			),
			'session_id' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Session Id is null or empty'
				)
			),
		),
		'flight_fare_rules'=>array(
			'auth_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'User Id is null or empty'
				)
			),
			'fare_source_code' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Fare Source Code is null or empty'
				)
			),
			'session_id' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Session Id is null or empty'
				)
			),
		),
		'flight_revalidate'=>array(
			'auth_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'User Id is null or empty'
				)
			),
			'fare_source_code' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Fare Source Code is null or empty'
				)
			),
			'session_id' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Session Id is null or empty'
				)
			),
		),
		'flight_book'=>array(
			'auth_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'User Id is null or empty'
				)
			),
			'target' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Target Field is null or empty'
				)
			),
			'session_id' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Session Id is null or empty'
				)
			),
			'area_code' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Area Code is null or empty'
				)
			),
			'country_code' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Country Code is null or empty'
				)
			),
			'first_name' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'First Name is null or empty'
				)
			),
			'last_name' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Last Name is null or empty'
				)
			),
			'title' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Title Field is null or empty'
				)
			),
			'email_id' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Email ID is null or empty'
				)
			),
			'mobile_no' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Mobile Number is null or empty'
				)
			),
			'dob' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'DOB is null or empty'
				)
			),
			'gender' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Gender is null or empty'
				)
			),
			'issue_country' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Issue Country is null or empty'
				)
			),
			'passport_expiry' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Passport Expiry Field is null or empty'
				)
			),
			'passport_no' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Passport Number is null or empty'
				)
			),
			'type' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Type Field is null or empty'
				)
			),
			'IsPassportMandatory' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Is Passport Mandatory Field is null or empty'
				)
			),
			'adult_flight' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Adult flight is null or empty'
				)
			),
			'child_flight' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Child Flight is null or empty'
				)
			),
			'infant_flight' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Infant Flight is null or empty'
				)
			),
			'frequentFlyrNum' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Frequent Flyr Number Field is null or empty'
				)
			),
			'child_dob' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Child Dob is null or empty'
				)
			),
			'child_gender' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Child Gender is null or empty'
				)
			),
			'child_title' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Child Title is null or empty'
				)
			),
			'child_first_name' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Child First Name is null or empty'
				)
			),
			'child_last_name' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Child Last Name is null or empty'
				)
			),
			'child_passport_expiry_date' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Child Passport Expiry Date is null or empty'
				)
			),
			'child_passport_no' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Child Passport Number is null or empty'
				)
			),
			'child_frequentFlyrNum' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Child Frequent Flyr Number is null or empty'
				)
			),
			'infant_dob' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Infant Dob is null or empty'
				)
			),
			'infant_gender' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Infant Gender is null or empty'
				)
			),
			'infant_first_name' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Infant First Name is null or empty'
				)
			),
			'infant_last_name' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Infant Last Name is null or empty'
				)
			),
			'infant_title' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Infant Title is null or empty'
				)
			),
			'FareSourceCode' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Fare Source Code is null or empty'
				)
			),
		),
		'flight_ticket_order'=>array(
			'auth_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'User Id is null or empty'
				)
			),
			'target' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Target Field is null or empty'
				)
			),
			'session_id' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Session Id is null or empty'
				)
			),
			'UniqueID' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Unique Id is null or empty'
				)
			),
		),
		'flight_trip_details'=>array(
			'auth_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'User Id is null or empty'
				)
			),
			'target' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Target Field is null or empty'
				)
			),
			'session_id' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Session Id is null or empty'
				)
			),
			'UniqueID' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Unique Id is null or empty'
				)
			),
		),
		'cancel_flights'=>array(
			'auth_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'User Id is null or empty'
				)
			),
			'target' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Target Field is null or empty'
				)
			),
			'session_id' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Session Field is null or empty'
				)
			),
			'UniqueID' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'Unique ID is null or empty'
				)
			),
		),
		'airportSearch'=>array(
			'auth_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'User Id is null or empty'
				)
			)
		),
		'flight_details'=>array(
			'auth_token' => array(
				'required' => array(
					'code' => 'ER02',
					'message' => 'User Id is null or empty'
				)
			),
			'flight_code' => array(
				'required' => array(
					'code' => 'ER20',
					'message' => 'Flight Code is null or empty'
				)
			),
		),
	);

	public function validation_check($method_name, $parms) {
 		$state = 0;
 		$rules = $this->validation_array[$method_name]; 		
 		$error_key = '';
 		foreach ($rules as $key => $value) {
 			foreach ($value as $keys => $values) {
 				switch ($keys) {
 						case 'required':
 							if(!isset($parms[$key]) || $parms[$key]=='' || $parms[$key]== null){
 								$state = 1;
 								$error_key = $values;
 							} 
 							break;
 						case 'email':
 							if (isset($parms[$key]) && !filter_var($parms[$key], FILTER_VALIDATE_EMAIL)) {
	  							$state = 1;
 								$error_key = $values; 
							} 
 							break;
 						case 'phone':
 							if(isset($parms[$key])){
 							$phone = preg_replace('/[^0-9]/', '', $parms[$key]);
	 							/*if (strlen($phone) !== 10) {
		  							$state = 1;
	 								$error_key = $values; 
								} */
							} 
 							break;


 						
 						default:
 							# code...
 							break;
 					}
 					if($state==1){
 						break;
 					}
 			}
 			if($state==1){
 				break;
 			}
 		}
 		return array('state'=>$state,'response'=>$error_key);
 	} 	
}
?>
