<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Category extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Category_model');
		$this->load->model('Dashboard_model');
		
		if(!$this->session->userdata('logged_in')) {
			redirect(base_url('Login'));
		}
 	}
	
	function listCategory(){
		$template['page'] = 'Category/viewCategoryList';
        $template['menu'] = 'Category Management';
        $template['smenu'] = 'View Category List';
        $template['pTitle'] = "Category Management";
        $template['pDescription'] = "View Category List";

        $template['categoryData'] = $this->Category_model->getCategoryData();
		$this->load->view('template',$template);
	}

	function addCategory(){
        $this->load->model('Category_model');
        $template['categoryData'] = $this->Category_model->getCategoryData();

		$template['page'] = 'Category/categoryAddForm';
        $template['menu'] = 'Category Management';
        $template['smenu'] = 'Add Category';
        $template['pTitle'] = "Add Category";
        $template['pDescription'] = "Create New Category";

		$this->load->view('template',$template);
	}

	function createCategory(){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');

		if(!isset($_POST) || empty($_POST)){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Category/addCategory'));
        }

		$err = 0;
        $errMsg = '';
        if($err == 0 && (!isset($_POST['category']) || empty($_POST['category']))){
            $err = 1;
            $errMsg = 'Provide a Category Name';
        } else if($err == 0 && (!isset($_POST['category_description']) || empty($_POST['category_description']))){
            $err = 1;
            $errMsg = 'Provide a Category Description';
        } else if($err == 0 && (!isset($_FILES) || empty($_FILES) || 
                                !isset($_FILES['category_image']) || empty($_FILES['category_image']))){
            $err = 1;
            $errMsg = 'Provide a Category Icon';
        }

        if($err == 0){
            $config = set_upload_service("assets/uploads/services");
            $this->load->library('upload');
            $config['file_name'] = time()."_".$_FILES['category_image']['name'];
            $this->upload->initialize($config);
            if(!$this->upload->do_upload('category_image')){
                $err = 1;
                $errMsg = $this->upload->display_errors();
            }else{
                $upload_data = $this->upload->data();
                $_POST['category_image'] = $config['upload_path']."/".$upload_data['file_name'];
            }
        }
        
        if($err == 1){
            $flashMsg['message'] = $errMsg;
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Category/addCategory'));
        }

        $status = $this->Category_model->createCategory($_POST);
        if($status == 1){
            $flashMsg['class'] = 'success';
            $flashMsg['message'] = 'Category Created';

            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Category/listCategory'));
        }
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Category/addCategory'));
	}

	function editCategory($category_id=''){
        $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($category_id) || empty(decode_param($category_id))){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Category/listCategory'));
		}
		$template['page'] = 'Category/categoryAddForm';
        $template['menu'] = 'Category Management';
        $template['smenu'] = 'Edit Category';
        $template['pTitle'] = "Edit Category";
        $template['pDescription'] = "Update Category Data";

        $template['category_id'] = $category_id;
        $template['categoryData'] = $this->Category_model->getCategoryData(decode_param($category_id));
		$this->load->view('template',$template);
	}

	function updateCategory($category_id=''){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');

		if(!isset($_POST) || empty($_POST) || empty($category_id)){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Category/listCategory'));
        }

		$err = 0;
        $errMsg = '';
        if($err == 0 && (!isset($_POST['category']) || empty($_POST['category']))){
            $err = 1;
            $errMsg = 'Provide a Category Name';
        } else if($err == 0 && (!isset($_POST['category_description']) || empty($_POST['category_description']))){
            $err = 1;
            $errMsg = 'Provide a Category Description';
        } else if($err == 0 && (!isset($_FILES) || empty($_FILES) || 
                                !isset($_FILES['category_image']) || empty($_FILES['category_image']))){
            $err = 1;
            $errMsg = 'Provide a Category Icon';
        }

        if($err == 0){
            $config = set_upload_service("assets/uploads/services");
            $this->load->library('upload');
            $config['file_name'] = time()."_".$_FILES['category_image']['name'];
            $this->upload->initialize($config);
            if($this->upload->do_upload('category_image')){
                $upload_data = $this->upload->data();
                $_POST['category_image'] = $config['upload_path']."/".$upload_data['file_name'];
            }
        }

        if($err == 1){
            $flashMsg['message'] = $errMsg;
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Category/editCategory/'.$category_id));
        }

        $status = $this->Category_model->updateCategory(decode_param($category_id),$_POST);
        if($status == 1){
            $flashMsg['class'] = 'success';
            $flashMsg['message'] = 'Category Created';

            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Category/listCategory'));
        }
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Category/editCategory/'.$category_id));
	}

    function changeStatus($category_id = '',$status = '1'){
        $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
        if(empty($category_id)){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Category/listCategory'));
        }
        $category_id = decode_param($category_id);
        $status = $this->Category_model->changeStatus($category_id,$status);
        if(!$status){
            $this->session->set_flashdata('message',$flashMsg);
        }
        redirect(base_url('Category/listCategory'));
    }
}
?>