<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Provider extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->model('Provider_model');

		if(!$this->session->userdata('logged_in')) {
			redirect(base_url());
		}
	}

	public function addProvider(){
		$template['page'] = 'Provider/providerForm';
        $template['menu'] = 'Provider Management';
        $template['smenu'] = 'Add Provider';
        $template['pTitle'] = "Add Provider";
        $template['pDescription'] = "Create New Provider";

		$this->load->view('template',$template);
	}

	public function viewProviders(){
		$template['page'] = 'Provider/viewProvider';
        $template['menu'] = 'Provider Management';
        $template['smenu'] = 'View Providers';
        $template['pTitle'] = "View Providers";
        $template['pDescription'] = "View and Manage Providers";
        $template['page_head'] = "Provider Management";

        $template['provider_data'] = $this->Provider_model->getProviderData('','0,1');

		$this->load->view('template',$template);
	}

	public function getProviderData(){
		$resArr = array('status'=>0);
		if(!isset($_POST)||empty($_POST)||!isset($_POST['provider_id'])||empty($_POST['provider_id']) || 
		   !is_numeric($provider_id = decode_param($_POST['provider_id']))){
			echo json_encode($resArr);exit;
		}
		$view_all = (isset($_POST['view_all']) && $_POST['view_all'] == 1)?1:0;
		$mechData = $this->Provider_model->getProviderData($provider_id,$view_all);

		if(empty($mechData)){
			echo json_encode($resArr);exit;
		}

		$resArr['status'] = 1;
		$resArr['data'] = $mechData;
		echo json_encode($resArr);exit;
	}

	function changeStatus($provider_id = '',$status = '1'){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($provider_id) || !is_numeric($provider_id = decode_param($provider_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Provider/viewProviders'));
		}
		$status = $this->Provider_model->changeStatus($provider_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Provider/viewProviders'));
	}

	public function createProvider(){
		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(!isset($_POST) || empty($_POST) || !isset($_FILES) || empty($_FILES)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Provider/addProvider'));
		}
		if($err == 0 && (!isset($_POST['display_name']) || empty($_POST['display_name']))){
			$err = 1;
			$errMsg = 'Provide a Display Name';
		}else if($err == 0 && (!isset($_POST['username']) || empty($_POST['username']))){
			$err = 1;
			$errMsg = 'Provide a User Name';
		}else if($err == 0 && (!isset($_POST['password']) || empty($_POST['password']) || 
								empty($_POST['password'] = md5($_POST['password'])))){
			$err = 1;
			$errMsg = 'Provide a Password';
		}else if($err == 0 && (!isset($_POST['name']) || empty($_POST['name']))){
			$err = 1;
			$errMsg = 'Provide a Name';
		}else if($err == 0 && (!isset($_POST['email']) || empty($_POST['email']))){
            $err = 1;
			$errMsg = 'Provide an Email ID';
        }else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
            $err = 1;
			$errMsg = 'Provide a Phone Number';
        }
        
        if($err == 0){
	        $config = set_upload_service("assets/uploads/services");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
	        $this->upload->initialize($config);
	        if(!$this->upload->do_upload('profile_image')){
	        	$err = 1;
				$errMsg = $this->upload->display_errors();
	        }else{
	            $upload_data = $this->upload->data();
	            $_POST['profile_image'] = $config['upload_path']."/".$upload_data['file_name'];
	        }
	    }

		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Provider/addProvider'));
		}

        $status = $this->Provider_model->addProvider($_POST);
        if($status == 1){
            $flashMsg =array('message'=>'Successfully Updated User Details..!','class'=>'success');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Provider/viewProviders'));
        } else if($status == 2){
            $flashMsg = array('message'=>'Email ID alrady exist..!','class'=>'error');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Provider/addProvider'));
        } else if($status == 3){
            $flashMsg = array('message'=>'Phone Number alrady exist..!','class'=>'error');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Provider/addProvider'));
        } else if($status == 4){
            $flashMsg = array('message'=>'User Name alrady exist..!','class'=>'error');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Provider/addProvider'));
        } else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Provider/addProvider'));
        }
	}

	public function editProviders($provider_id){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($provider_id) || !is_numeric($provider_id = decode_param($provider_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Provider/viewProviders'));
		}

		$template['page'] = 'Provider/providerForm';
        $template['menu'] = 'Provider Management';
        $template['smenu'] = 'Edit Provider';
        $template['pTitle'] = "Edit Providers";
        $template['pDescription'] = "Update Provider Data";

        $template['provider_data'] = $this->Provider_model->getProviderData($provider_id,1);
        $template['provider_id'] = encode_param($provider_id);
		$this->load->view('template',$template);
	}

	public function updateProvider($provider_id = ''){
		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(!isset($_POST) || empty($_POST) || !isset($_FILES) || empty($_FILES)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Provider/addProvider'));
		}
		if($err == 0 && (!isset($_POST['display_name']) || empty($_POST['display_name']))){
			$err = 1;
			$errMsg = 'Provide a Display Name';
		}else if($err == 0 && (!isset($_POST['username']) || empty($_POST['username']))){
			$err = 1;
			$errMsg = 'Provide a User Name';
		}else if($err == 0 && (!isset($_POST['name']) || empty($_POST['name']))){
			$err = 1;
			$errMsg = 'Provide a Name';
		}else if($err == 0 && (!isset($_POST['email']) || empty($_POST['email']))){
            $err = 1;
			$errMsg = 'Provide an Email ID';
        }else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
            $err = 1;
			$errMsg = 'Provide a Phone Number';
        }
    	
        if($err == 0){
	        $config = set_upload_service("assets/uploads/services");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
	        $this->upload->initialize($config);
	        if($this->upload->do_upload('profile_image')){
	            $upload_data = $this->upload->data();
	            $_POST['profile_image'] = $config['upload_path']."/".$upload_data['file_name'];
	        }
	    }

		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Provider/editProviders/'.$provider_id));
		}
		
        $status = $this->Provider_model->updateProvider(decode_param($provider_id),$_POST);
        if($status == 1){
            $flashMsg =array('message'=>'Successfully Updated User Details..!','class'=>'success');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Provider/viewProviders'));
        } else if($status == 2){
            $flashMsg = array('message'=>'Email ID alrady exist..!','class'=>'error');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Provider/editProviders/'.$provider_id));
        } else if($status == 3){
            $flashMsg = array('message'=>'Phone Number alrady exist..!','class'=>'error');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Provider/editProviders/'.$provider_id));
        } else if($status == 4){
            $flashMsg = array('message'=>'User Name alrady exist..!','class'=>'error');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Provider/editProviders/'.$provider_id));
        } else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Provider/editProviders/'.$provider_id));
        }
	}
}
?>