<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class FlightBooking extends CI_Controller {

	public function __construct() {
		parent::__construct();
    	date_default_timezone_set("Asia/Riyadh");
		$this->load->model('FlightBooking_model');

		if(!$this->session->userdata('logged_in')) {
			redirect(base_url());
		}
	}

	public function encode($val = ''){
		echo encode_param($val);
	}

	public function decode($val = ''){
		echo decode_param($val);
	}

	public function viewBookings(){
		$template['page'] = 'FlightBooking/viewBooking';
        $template['menu'] = 'Flight Booking Management';
        $template['smenu'] = 'View Flight Bookings';
        $template['pTitle'] = "View Flight Bookings";
        $template['pDescription'] = "View and Manage Flight Bookings";
        $template['page_head'] = "Flight Booking Management";

        $template['booking_data'] = $this->FlightBooking_model->getFlightBookingData();
        //pr($template['booking_data']);
		$this->load->view('template',$template);
	}

	public function getFlightBookingData(){
		$resArr = array('status'=>0);
		if(!isset($_POST)||empty($_POST)||!isset($_POST['booking_id'])||empty($_POST['booking_id'])){
			echo json_encode($resArr);exit;
		}
		$bookData['bookData'] = $this->FlightBooking_model->getFlightBookingData(decode_param($_POST['booking_id']));

        $viewPage = $this->load->view('FlightBooking/viewFlightBookingDetails',$bookData,true);

        echo $viewPage;exit;
	}
}
?>
