<?php 

class FlightServices_model extends CI_Model {
	
	public function _consruct(){
		parent::_construct();
	}

    public function auth_token_get($token) {
        $rs = $this->db->select('user_id')->where('auth_token', $token)->get('customer_auth')->row();
        if(count($rs) > 0) {
            return $rs->user_id;
        } else {
            return 0;
        }
    }

    public function flight_authenticate($data){
    	try{
    		$user_id = $this->auth_token_get($data['auth_token']);
    		if($user_id > 0){
    			$settings = getSettings();
    			$url = "https://trawex.biz/api/flight_trawex/authenticate?user_id=".$settings['trawex_user_id']."&user_password=".$settings['trawex_user_password']."&access=".$settings['trawex_access']."&ip_address=".$settings['trawex_ip_address']."";
    			$result = $this->passToJsonCurl($url,'');
    			if(!empty($result)){
    				$result = json_decode($result);
    				$res = array('status'=>1,'data'=>$result);
    			}else{
    				$res = array('status'=>0,'message'=>'No Data Found','code'=>'ER06');
    			}
    		}else{
    			$res = array('status'=>0,'message'=>'User Authentication Error','code'=>'ER10');
    		}
    	}catch(Exception $e){
    		$res = array('status'=>0,'message'=>'Ohh No!! Something Went South!!','code'=>'ER08');
    	}
    	return $res;
    }

    public function flight_availability_search($data){
    	try{
    		$user_id = $this->auth_token_get($data['auth_token']);
    		if($user_id > 0){
    			$settings = getSettings();
                $return_date = (isset($data['return_date']) && !empty($data['return_date']))?$data['return_date']:'';
    			$url = "https://trawex.biz/api/flight_trawex/flight_availability_search?user_id=".$settings['trawex_user_id']."&user_password=".$settings['trawex_user_password']."&access=".$settings['trawex_access']."&ip_address=".$settings['trawex_ip_address']."&session_id=".$data['session_id']."&journey_type=".$data['journey_type']."&airport_from_code=".$data['airport_from_code']."&airport_to_code=".$data['airport_to_code']."&departure_date=".$data['departure_date']."&return_date=".$return_date."&adult_flight=".$data['adult_flight']."&child_flight=".$data['child_flight']."&infant_flight=".$data['infant_flight']."&class=".$data['class']."&target=".$data['target']."";
    			$result = $this->passToJsonCurl($url,'');
    			if(!empty($result)){
    				$result = json_decode($result);
    				$res = array('status'=>1,'data'=>$result);
    			}else{
    				$res = array('status'=>0,'message'=>'No Data Found','code'=>'ER08');
    			}
    		}else{
    			$res = array('status'=>0,'message'=>'User Authentication Error','code'=>'ER06');
    		}
    	}catch(Exception $e){
    		$res = array('status'=>0,'message'=>'Ohh No!! Something Went South','code'=>'ER10');
    	}
    	return $res;
    }

    public function flight_fare_rules($data){
    	try{
    		$user_id = $this->auth_token_get($data['auth_token']);
    		if($user_id > 0){
    			$settings = getSettings();
    			$url = "https://trawex.biz/api/flight_trawex/fare_rules?user_id=".$settings['trawex_user_id']."&user_password=".$settings['trawex_user_password']."&access=".$settings['trawex_access']."&ip_address=".$settings['trawex_ip_address']."&fare_source_code=".$data['fare_source_code']."&session_id=".$data['session_id']."";
    			$result = $this->passToJsonCurl($url,'');
    			if(!empty($result)){
    				$result = json_decode($result);
    				$res = array('status'=>1,'data'=>$result);
    			}else{
    				$res = array('status'=>0,'message'=>'No Data Found','code'=>'ER08');
    			}
    		}else{
    			$res = array('status'=>0,'message'=>'User Authentication Error','code'=>'ER06');
    		}
    	}catch(Exception $e){
    		$res = array('status'=>0,'message'=>'Ohh No!! Something Went South','code'=>'ER10');
    	}
    	return $res;
    }

    public function flight_revalidate($data){
    	try{
    		$user_id = $this->auth_token_get($data['auth_token']);
    		if($user_id > 0){
    			$settings = getSettings();
    			$url = "https://trawex.biz/api/flight_trawex/revalidate?user_id=".$settings['trawex_user_id']."&user_password=".$settings['trawex_user_password']."&access=".$settings['trawex_access']."&ip_address=".$settings['trawex_ip_address']."&fare_source_code=".$data['fare_source_code']."&session_id=".$data['session_id']."";
    			$result = $this->passToJsonCurl($url,'');
    			if(!empty($result)){
    				$result = json_decode($result);
    				$res = array('status'=>1,'data'=>$result);
    			}else{
    				$res = array('status'=>0,'message'=>'No Data Found','code'=>'ER08');
    			}
    		}else{
    			$res = array('status'=>0,'message'=>'User Authentication Error','code'=>'ER06');
    		}
    	}catch(Exception $e){
    		$res = array('status'=>0,'message'=>'Ohh No!! Something Went South','code'=>'ER10');
    	}
    	return $res;
    }

    public function flight_book($data){
    	try{
    		$user_id = $this->auth_token_get($data['auth_token']);
    		if($user_id > 0){
    			$settings = getSettings();
    			$data['first_name'] = str_replace(" ","<br>",$data['first_name']);
    			$data['last_name'] = str_replace(" ","<br>",$data['last_name']);
    			$data['title'] = str_replace(" ","<br>",$data['title']);
    			$data['dob'] = str_replace(" ","<br>",$data['dob']);
    			$data['gender'] = str_replace(" ","<br>",$data['gender']);
    			$data['issue_country'] = str_replace(" ","<br>",$data['issue_country']);
    			$data['passport_expiry'] = str_replace(" ","<br>",$data['passport_expiry']);
    			$data['passport_no'] = str_replace(" ","<br>",$data['passport_no']);
                $childMealplan = (isset($data['childMealplan']) && !empty($data['childMealplan']))?$data['childMealplan']:'';
                $infantMealplan = (isset($data['infantMealplan']) && !empty($data['infantMealplan']))?$data['infantMealplan']:'';
                $adultmealplan = (isset($data['adultmealplan']) && !empty($data['adultmealplan']))?$data['adultmealplan']:'';
                $postCode = (isset($data['PostCode']) && !empty($data['PostCode']))?$data['PostCode']:'';

    			$url = "https://trawex.biz/api/flight_trawex/book?user_id=".$settings['trawex_user_id']."&user_password=".$settings['trawex_user_password']."&access=".$settings['trawex_access']."&ip_address=".$settings['trawex_ip_address']."&target=".$data['target']."&session_id=".$data['session_id']."&area_code=".$data['area_code']."&country_code=".$data['country_code']."&first_name=".$data['first_name']."&last_name=".$data['last_name']."&title=".$data['title']."&email_id=".$data['email_id']."&mobile_no=".$data['mobile_no']."&dob=".$data['dob']."&gender=".$data['gender']."&issue_country=".$data['issue_country']."&passport_expiry=".$data['passport_expiry']."&passport_no=".$data['passport_no']."&type=".$data['type']."&IsPassportMandatory=".$data['IsPassportMandatory']."&adult_flight=".$data['adult_flight']."&child_flight=".$data['child_flight']."&infant_flight=".$data['infant_flight']."&frequentFlyrNum=".$data['frequentFlyrNum']."&adultmealplan=".$adultmealplan."&child_dob=".$data['child_dob']."&child_gender=".$data['child_gender']."&child_title=".$data['child_title']."&child_first_name=".$data['child_first_name']."&child_last_name=".$data['child_last_name']."&child_passport_expiry_date=".$data['child_passport_expiry_date']."&child_passport_no=".$data['child_passport_no']."&child_frequentFlyrNum=".$data['child_frequentFlyrNum']."&childMealplan=".$childMealplan."&infant_dob=".$data['infant_dob']."&infant_gender=".$data['infant_gender']."&infant_first_name=".$data['infant_first_name']."&infant_last_name=".$data['infant_last_name']."&infant_title=".$data['infant_title']."&infantMealplan=".$infantMealplan."&FareSourceCode=".$data['FareSourceCode']."&PostCode=".$postCode."";
    			$result = $this->passToJsonCurl($url,'');
    			if(!empty($result)){
    				//$result = json_decode($result);
                    $result = array('BookFlightResponse'=>array('BookFlightResult'=>array('Errors'=>'','Status'=>'CONFIRMED','Success'=> 'true','Target'=> 'Test','TktTimeLimit'=>'', 'UniqueID'=>'TR04632018')));
                    // $result = "{'BookFlightResponse': {'BookFlightResult': {'Errors': '','Status': 'CONFIRMED','Success': 'true','Target': 'Test','TktTimeLimit': 'UniqueID': 'TR04632018'}}}";
    				$res = array('status'=>1,'data'=>$result);
    			}else{
    				$res = array('status'=>0,'message'=>'No Data Found','code'=>'ER08');
    			}
    		}else{
    			$res = array('status'=>0,'message'=>'User Authentication Error','code'=>'ER06');
    		}
    	}catch(Exception $e){
    		$res = array('status'=>0,'message'=>'Ohh No!! Something Went South','code'=>'ER10');
    	}
    	return $res;
    }

    public function flight_ticket_order($data){
    	try{
    		$user_id = $this->auth_token_get($data['auth_token']);
    		if($user_id > 0){
    			$settings = getSettings();
    			$url = "https://trawex.biz/api/flight_trawex/ticket_order?user_id=".$settings['trawex_user_id']."&user_password=".$settings['trawex_user_password']."&access=".$settings['trawex_access']."&ip_address=".$settings['trawex_ip_address']."&UniqueID=".$data['UniqueID']."&target=".$data['target']."&session_id=".$data['session_id']."";
    			$result = $this->passToJsonCurl($url,'');
    			if(!empty($result)){
    				$result = json_decode($result);
    				$res = array('status'=>1,'result'=>$result);
    			}else{
    				$res = array('status'=>0,'message'=>'No data Found','code'=>'ER08');
    			}
    		}else{
    			$res = array('status'=>0,'message'=>'User Authentication Error','code'=>'ER06');
    		}
    	}catch(Exception $e){
    		$res = array('status'=>0,'message'=>'Ohh No!! Something Went South','code'=>'ER10');
    	}
    	return $res;
    }

    public function flight_trip_details($data){
    	try{
    		$user_id = $this->auth_token_get($data['auth_token']);
    		if($user_id > 0){
    			$settings = getSettings();
    			$url = "https://trawex.biz/api/flight_trawex/trip_details?user_id=".$settings['trawex_user_id']."&user_password=".$settings['trawex_user_password']."&access=".$settings['trawex_access']."&ip_address=".$settings['trawex_ip_address']."&UniqueID=".$data['UniqueID']."&target=".$data['target']."&session_id=".$data['session_id']."";
    			$result = $this->passToJsonCurl($url,'');
    			if(!empty($result)){
    				$result = json_decode($result);
    				$res = array('status'=>1,'result'=>$result);
    			}else{
    				$res = array('status'=>0,'message'=>'No Data Found','code'=>'ER08');
    			}
    		}else{
    			$res = array('status'=>0,'message'=>'User Authentication Error','code'=>'ER06');
    		}
    	}catch(Exception $e){
    		$res = array('status'=>0,'message'=>'Ohh No!! Something Went South','code'=>'ER10');
    	}
    	return $res;
    }

    public function  cancel_flights($data){
    	try{
    		$user_id = $this->auth_token_get($data['auth_token']);
    		if($user_id > 0){
    			$settings = getSettings();
    			$url = "https://trawex.biz/api/flight_trawex/cancel_flights?user_id=".$settings['trawex_user_id']."&user_password=".$settings['trawex_user_password']."&access=".$settings['trawex_access']."&ip_address=".$settings['trawex_ip_address']."&UniqueID=".$data['UniqueID']."&target=".$data['target']."&session_id=".$data['session_id']."";
    		}else{
    			$res = array('status'=>0,'message'=>'User Authentication Error','code'=>'ER06');
    		}
    	}catch(Exception $e){
    		$res = array('status'=>0,'message'=>'Ohh No!! Something Went South','code'=>'ER10');
    	}
    	return $res;
    }

    public function airportSearch($data){
    	try{
			$cond = '';
			if(isset($data['query']) && !empty($data['query'])){
				$cond = "WHERE airport_code LIKE '%".$data['query']."%' OR airport_name LIKE '%".$data['query']."%' OR city LIKE '%".$data['query']."%'";
			}
			$sql = "SELECT id FROM airport_details $cond";
			$count = $this->db->query($sql)->num_rows();
			if($count > 0){
    			$perPage = 10;
				$page = (isset($data['page']))?$data['page']:1;
				$limit = ($page - 1) * $perPage;
				$meta = array('total_pages'=>ceil($count/$perPage),'total'=>$count,
						  'current_page'=>$page,'per_page'=>$perPage);
    			$sql = "SELECT * FROM airport_details $cond LIMIT $limit,$perPage";
    			$airPortList = $this->db->query($sql);
    			if(!isset($airPortList) || empty($airPortList = $airPortList->result_array())){
    				$res = array('status'=>0,'message'=>'No data Found','code'=>'ER04');
    				return $res;
    			}
    			$res =array('status'=>1,'data'=>array('airportlist'=>$airPortList,'meta'=>$meta));
			}
    	}catch(Exception $e){
    		$res = array('status'=>0,'message'=>'Ohh No!! Something Went South','code'=>'ER10');
    	}
    	return $res;
    }

    public function flight_details($data){
        try{
            $user_id = $this->auth_token_get($data['auth_token']);
            if($user_id > 0){
                $sql = "SELECT * FROM flight_details WHERE flight_code='".$data['flight_code']."'";
                $query = $this->db->query($sql);
                if(empty($query) || empty($flightDetails = $query->row_array())){
                    $res = array('status'=>0,'message'=>'No Data Found','code'=>'ER06');
                    return $res;
                }
                $res = array('status'=>1,'data'=>$flightDetails);
            }else{
                $res = array('status'=>0,'message'=>'User Authentication Error','code'=>'ER08');
            }
        }catch(Exception $e){
            $res = array('status'=>0,'message'=>'Ohh No!! Something Went South','code'=>'ER10');
        }
        return $res;
    }

    public function passToJsonCurl($url='',$postData=array()){
    	$ch = curl_init();
	    curl_setopt($ch,CURLOPT_URL,$url);
	    curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
	    curl_setopt($ch,CURLOPT_POST,1);
	    curl_setopt($ch,CURLOPT_POSTFIELDS,json_encode($postData));  
	    curl_setopt($ch,CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch,CURLOPT_SSL_VERIFYPEER, false);
	    curl_setopt($ch,CURLOPT_HTTPHEADER,array('Content-Type:application/json')); 
	    $result = curl_exec($ch);
	    curl_close($ch);
	    return $result;
    }
}
?>
