<?php 

class HotelServices_model extends CI_Model {
	
	public function _consruct(){
		parent::_construct();
	}

	public function auth_token_get($token) {
		$rs = $this->db->select('user_id')->where('auth_token', $token)->get('customer_auth')->row();
		if(count($rs) > 0) {
			return $rs->user_id;
		} else {
			return 0;
		}
	}

    public function get_hotel_city_list($data){ 
    	try{
			$cond = '';
			if(isset($data['query']) && !empty($query = urldecode(strtolower($data['query'])))){
				$cond = "AND THC.hotel_city_name LIKE '%".$query."%'";
			}
			$sql = "SELECT HC.hotel_city_id FROM hotel_cities AS HC
					INNER JOIN translator_hotel_city AS THC ON(THC.hotel_city_id=HC.hotel_city_id)
					WHERE HC.status=1 $cond GROUP BY HC.hotel_city_id";
			$count = $this->db->query($sql)->num_rows();
			if($count >= 1){	
				$perPage = 10;
				$page = (isset($data['page']))?$data['page']:1;
				$limit = ($page - 1) * $perPage;
				$meta = array('total_pages'=>ceil($count/$perPage),'total'=>$count,
						      'current_page'=>$page,'per_page'=>$perPage);
				$sql = "SELECT THC.hotel_city_id AS id,HC.hotel_city_icon AS image,HC.country
					    FROM translator_hotel_city AS THC
					    INNER JOIN hotel_cities AS HC ON (HC.hotel_city_id=THC.hotel_city_id) 
					    WHERE HC.status=1 $cond GROUP BY HC.hotel_city_id LIMIT $limit,$perPage";
				$hotelData = $this->db->query($sql)->result_array();

				$lang = 'EN';
				if(isset($data['auth_token']) && !empty($data['auth_token'])){
					$user_id = $this->auth_token_get($data['auth_token']);
					if($user_id > 0) {
						$countryData = $this->getCountryData($user_id);
						$lang = $countryData['language_code'];
					}
				}

				foreach ($hotelData as $key => $value) {
					if(!empty($lanTrans = langTranslator($value['id'],'HCTY'))){
						$lanTrans['name'] = (!empty($lanTrans['hotel_city_name_'.$lang]))?
												$lanTrans['hotel_city_name_'.$lang]:
												$lanTrans['hotel_city_name_EN'];
						$hotelData[$key] = array_merge($hotelData[$key],$lanTrans);
					}
				}
				if(count($hotelData) < 0){
					$res = array('status'=>0,'message'=>'No Data Found','code'=>'ER10');
				}
				$res = array('status'=>1,'data'=>array('city_list'=>$hotelData,'meta'=>$meta));
			}else{
				$res = array('status'=>0,'message'=>'No Data Found','code'=>'ER10');
			}
    	} catch(Exception $e){
    		$res = array('status'=>0,'message'=>'Ohh No!! Something Went South!!','code'=>'ER08');
    	}
    	return $res;
    }

    public function hotel_search($data){
    	try{
    		$user_id = $this->auth_token_get($data['auth_token']);
			if($user_id > 0) {
	    		$trackingId = time().rand(100000,999999);
	    		$settings = getSettings();
				$countryData = $this->getCountryData($user_id);
	    		if(!isset($data['nextToken']) && empty($data['nextToken'])){
					$this->db->select('nationality');
					$userData = $this->db->get_where('customer',array('customer_id'=>$user_id))->row_array();
	    		}
				$url = (isset($data['nextToken']) && !empty($data['nextToken']))?"https://trawex.biz/api/hotel_trawexv5/getMoreHotels?user_id=".$settings['trawex_user_id']."&user_password=".$settings['trawex_user_password']."&access=".$settings['trawex_access']."&ip_address=".$settings['trawex_ip_address']."&sessionId=".$data['sessionId']."&nextToken=".$data['nextToken']."&trackingId=".$data['trackingId']."":"https://trawex.biz/api/hotel_trawexv5/hotel_search";
				if(!isset($data['nextToken']) && empty($data['nextToken'])){
					$postData = array('user_id'=>$settings['trawex_user_id'],
								  'user_password'=>$settings['trawex_user_password'],
								  'access'=>$settings['trawex_access'],
								  'ip_address'=>$settings['trawex_ip_address'],
								  'trackingId'=>$trackingId,'city_name'=>$data['city_name'],
								  'country_name'=>$data['country_name'],
								  'room_count'=>$data['room_count'],'adult'=>$data['adult'],
								  'child'=>$data['child'],'child_age'=>$data['child_age'],
								  'checkin'=>$data['checkin'],'checkout'=>$data['checkout'],
								  'client_nationality'=>$userData['nationality'],
								  'requiredCurrency'=>'SAR');
				}

			    $postFields = (isset($data['nextToken']) && !empty($data['nextToken']))?'':$postData;
			    $result = passToJsonCurl($url,$postFields);
			    if(!empty($result)){
			    	$result = json_decode($result);
			    	$result->status->trackingId = (!isset($data['nextToken']) && empty($data['nextToken']))?$trackingId:$data['trackingId'];
			    	$data = array("itineraries"=>$result,"currency_symbol"=>$countryData['currency_symbol'],
			    		          "conversion_rate"=>$countryData['conversion_rate']);
			    	$res = array('status'=>1,'data'=>$data);
			    }else{
			    	$res = array('status'=>0,'message'=>'No Data Found','code'=>'ER07');
			    }
			}else{
				$res = array('status'=>0,'message'=>'User Authentication Error','code'=>'ER10');
			}
    	}catch(Exception $e){
    		$res = array('status'=>0,'message'=>'Ohh No!! Something Went South!!','code'=>'ER08');
    	}
    	return $res;
    }

    public function get_specific_hotel_content($data){
    	try{
    		$user_id = $this->auth_token_get($data['auth_token']);
			if($user_id > 0) {
    			$settings = getSettings();
				$url = "https://trawex.biz/api/hotel_trawexv5/get_specific_hotel_content?user_id=".$settings['trawex_user_id']."&user_password=".$settings['trawex_user_password']."&access=".$settings['trawex_access']."&ip_address=".$settings['trawex_ip_address']."&sessionId=".$data['sessionId']."&trackingId=".$data['trackingId']."&productId=".$data['productId']."&hotelId=".$data['hotelId']."";
				$result = passToJsonCurl($url,'');
			    if(!empty($result)){
			    	$result = json_decode($result,true);
			    	$countryData = $this->getCountryData($user_id);

			    	$result['trackingId'] = $data['trackingId'];
			    	$result['conversion_rate'] = $countryData['conversion_rate'];
			    	$result['currency_symbol'] = $countryData['currency_symbol'];
			    	$res = array('status'=>1,'data'=>$result);
			    }else{
			    	$res = array('status'=>0,'message'=>'No Data Found','code'=>'ER06');
			    }
			}else{
				$res = array('status'=>0,'message'=>'User Authentication Error','code'=>'ER10');
			}
    	}catch(Exception $e){
    		$res = array('status'=>0,'message'=>'Ohh No!! Something Went South!!','code'=>'ER08');
    	}
    	return $res;
    }

    public function get_room_rates($data){
    	try{
    		$user_id = $this->auth_token_get($data['auth_token']);
    		if($user_id > 0){
    			$settings = getSettings();
    			$url = "https://trawex.biz/api/hotel_trawexv5/get_room_rates";
    			$postData = array("user_id"=>$settings['trawex_user_id'],"user_password"=>$settings['trawex_user_password'],"access"=>$settings['trawex_access'],"ip_address"=>$settings['trawex_ip_address'],"TraceId"=>$data['TraceId'],"propertyid"=>$data['propertyid'],"trackingId"=>$data['trackingId'],"sessionId"=>$data['sessionId'],"productId"=>$data['productId'],"TokenId"=>$data['TokenId'],"resultindex"=>$data['resultindex'],"hotelcode"=>$data['hotelcode']);
    			$result = passToJsonCurl($url,$postData);
			    if(!empty($result)){
			    	$result = json_decode($result,true);
			    	$countryData = $this->getCountryData($user_id);
			    	
			    	$result['trackingId'] = $data['trackingId'];
			    	$result['conversion_rate'] = $countryData['conversion_rate'];
			    	$result['currency_symbol'] = $countryData['currency_symbol'];
			    	$res = array('status'=>1,'data'=>$result);
			    }else{
			    	$res = array('status'=>0,'message'=>'No data Found','code'=>'ER06');
			    }
    		}else{
    			$res = array('status'=>0,'message'=>'User Authentication Error','code'=>'ER10');
    		}
    	}catch (Exception $e){
    		$res = array('status'=>0,'message'=>'Ohh No!! Something Went South!!','code'=>'ER08');
    	}
    	return $res;
    }

    public function get_rate_rules($data){
    	try{
    		$user_id = $this->auth_token_get($data['auth_token']);
    		if($user_id > 0){
    			$settings = getSettings();
    			$url = "https://trawex.biz/api/hotel_trawexv5/get_rate_rules";
    			$postData = array(
    							"user_id"=>$settings['trawex_user_id'],
    							"user_password"=>$settings['trawex_user_password'],
    							"access"=>$settings['trawex_access'],
    							"ip_address"=>$settings['trawex_ip_address'],
    							"TraceId"=>$data['TraceId'],"propertyid"=>$data['propertyid'],
    							"trackingId"=>$data['trackingId'],"sessionId"=>$data['sessionId'],
    							"productId"=>$data['productId'],"TokenId"=>$data['TokenId'],
    							"resultindex"=>$data['resultindex'],"hotelcode"=>$data['hotelcode'],
    							"allocationDetails"=>$data['allocationDetails'],
    							"booking_token"=>$data['booking_token'],
    							"hotel_name"=>$data['hotel_name'],"infosource"=>$data['infosource'],
    							"meal_code"=>$data['meal_code'],
    							"rate_basis_id"=>$data['rate_basis_id'],
    							"room_code"=>$data['room_code'],"boardCode"=>$data['boardCode'],
    							"roomType_runno"=>$data['roomType_runno']);
    			$result = passToJsonCurl($url,$postData);
			    if(!empty($result)){
			    	$result = json_decode($result,true);
			    	$countryData = $this->getCountryData($user_id);
			    	
			    	$result['trackingId'] = $data['trackingId'];
			    	$result['conversion_rate'] = $countryData['conversion_rate'];
			    	$result['currency_symbol'] = $countryData['currency_symbol'];
			    	$res = array('status'=>1,'data'=>$result);
			    }else{
			    	$res = array('status'=>0,'message'=>'No data Found','code'=>'ER06');
			    }
    		}else{
    			$res = array('status'=>0,'message'=>'User Authentication Error','code'=>'ER10');
    		}
    	} catch(Exception $e){
    		$res = array('status'=>0,'message'=>'Ohh No!! Something Went South!!','code'=>'ER08');
    	}
    	return $res;
    }

    public function hotel_book($data){
    	try{
    		$user_id = $this->auth_token_get($data['auth_token']);
    		if($user_id > 0){
    			$settings = getSettings();
    			$url = "https://trawex.biz/api/hotel_trawexv5/hotel_book";
    			$postData = array(
    							"user_id"=>$settings['trawex_user_id'],
    							"user_password"=>$settings['trawex_user_password'],
    							"access"=>$settings['trawex_access'],
    							"ip_address"=>$settings['trawex_ip_address'],
    							"TraceId"=>$data['TraceId'],"propertyid"=>$data['propertyid'],
    							"trackingId"=>$data['trackingId'],"sessionId"=>$data['sessionId'],
    							"productId"=>$data['productId'],"TokenId"=>$data['TokenId'],
    							"resultindex"=>$data['resultindex'],"hotelcode"=>$data['hotelcode'],
    							"changedOccupancy"=>$data['changedOccupancy'],
    							"extrabeds"=>$data['extrabeds'],
    							"guests_details"=>$data['guests_details'],"refcode"=>$data['refcode'],
    							"prebookingtoken"=>$data['prebookingtoken']
    						);
    			$result = passToJsonCurl($url,$postData);
			    if(!empty($result)){
			    	$result = json_decode($result,true);
			    	$countryData = $this->getCountryData($user_id);
			    	
			    	$result['trackingId'] = $data['trackingId'];
			    	$result['conversion_rate'] = $countryData['conversion_rate'];
			    	$result['currency_symbol'] = $countryData['currency_symbol'];
			    	$res = array('status'=>1,'data'=>$result);
			    }else{
			    	$res = array('status'=>0,'message'=>'No data Found','code'=>'ER06');
			    }
    		}else{
    			$res = array('status'=>0,'message'=>'User Authentication Error','code'=>'ER10');
    		}
    	} catch(Exception $e){
    		$res = array('status'=>0,'message'=>'Ohh No!! Something Went South!!','code'=>'ER08');
    	}
    	return $res;
    }

    public function trawex_cancel_booking($data){
    	try{
    		$user_id = $this->auth_token_get($data['auth_token']);
    		if($user_id > 0){
    			$settings = getSettings();
    			$url = "https://trawex.biz/api/hotel_trawexv5/cancel_booking";
    			$postData = array(
							"user_id"=>$settings['trawex_user_id'],
							"user_password"=>$settings['trawex_user_password'],
							"access"=>$settings['trawex_access'],
							"ip_address"=>$settings['trawex_ip_address'],
    						'trackingId'=>$data['trackingId'],'productId'=>$data['productId'],
    						'supplierConfirmationNum'=>$data['supplierConfirmationNum'],
    						'reference'=>$data['reference']
    					);
    			$result = passToJsonCurl($url,$postData);
			    if(!empty($result)){
			    	$result = json_decode($result,true);
			    	$countryData = $this->getCountryData($user_id);
			    	
			    	$result['trackingId'] = $data['trackingId'];
			    	$result['conversion_rate'] = $countryData['conversion_rate'];
			    	$result['currency_symbol'] = $countryData['currency_symbol'];
			    	$res = array('status'=>1,'data'=>$result);
			    }else{
			    	$res = array('status'=>0,'message'=>'No data Found','code'=>'ER06');
			    }
    		}else{
    			$res = array('status'=>0,'message'=>'User Authentication Error','code'=>'ER10');
    		}
    	} catch(Exception $e){
    		$re = array('status'=>0,'message'=>'Ohh No!! Something Went South!!','code'=>'ER08');
    	}
    	return $res;
    }

    
	public function getCountryData($user_id){
		$ctryData = '';
		if(!empty($user_id)){
			$sql = "SELECT CTRY.* FROM customer AS CUST 
		      	    INNER JOIN country AS CTRY ON (CTRY.country_id=CUST.country_id)
		      	    WHERE CUST.customer_id='$user_id'";
			$ctryData = $this->db->query($sql)->row_array();
		}

		if(empty($ctryData)){
			$ctryData = $this->db->query("SELECT * FROM country WHERE language_code='EN'")->row_array();
		}
		return $ctryData;
	}

  //   public function passToJsonCurl($url='',$postData=array()){
  //   	$ch = curl_init();
	 //    curl_setopt($ch,CURLOPT_URL,$url);
	 //    curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
	 //    curl_setopt($ch,CURLOPT_POST,1);
	 //    curl_setopt($ch,CURLOPT_POSTFIELDS,json_encode($postData));  
	 //    curl_setopt($ch,CURLOPT_SSL_VERIFYHOST, false);
		// curl_setopt($ch,CURLOPT_SSL_VERIFYPEER, false);
	 //    curl_setopt($ch,CURLOPT_HTTPHEADER,array('Content-Type:application/json')); 
	 //    $result = curl_exec($ch);
	 //    curl_close($ch);
	 //    return $result;
  //   }
}
?>
