<div class="content-wrapper" >
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
       <?= $pTitle ?>
        <small><?= $pDescription ?></small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
      <li><?= $menu ?></li>
      <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <!-- Main content -->
  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
             <button class="close" data-dismiss="alert" type="button">×</button>
             <?= $flashdata['message'] ?>
          </div>
        <?php } ?>
      </div>
      <div class="col-xs-12">
        <div class="box box-warning"> 
          <div class="box-header with-border">
            <div class="col-md-6"><h3 class="box-title">Hotel Booking List</h3></div>
            <div class="col-md-6" align="right">
              <a class="btn btn-sm btn-primary" href="<?= base_url() ?>">Back</a>
            </div>
          </div>
          <div class="box-body">
            <table id="mechanicUsers" class="table table-bordered table-striped datatable ">
              <thead>
                <tr>
                  <th class="hidden">ID</th>
                  <th width="50px;">Book ID</th>
                  <th width="130px;">Hotel Name</th>
                  <th width="130px;">Customer</th>
                  <th width="130px;">Check In</th>
                  <th width="130px;">Check Out</th>
                  <th width="50px;">Amount</th>
                  <th width="50px;">Transaction Id</th>
                  <th width="50px;">Status</th>
                  <th width="40px;">Action</th>
               </tr>
              </thead> 
              <tbody>
                <?php
                if(!empty($booking_data)){
                  foreach($booking_data as $booking) { ?>
                    <tr>
                      <th class="hidden"><?= $booking->id ?></th>
                      <th class="center"><?= $booking->hotel_book_id ?></th>
                      <th class="center"><?= $booking->hotel_name ?></th>
                      <th class="center"><?= $booking->customer_name ?></th>
                      <th class="center"><?= $booking->checkin ?></th>
                      <th class="center"><?= $booking->checkout?></th>
                      <th class="center"><?= $booking->price ?></th>
                      <th class="center"><?= ($booking->transaction_id != '')?$booking->transaction_id:' -- ' ?></th>
                      <th class="center" id="bookingStatus_<?= encode_param($booking->hotel_book_id) ?>">
                        <?php 
                          switch($booking->status){
                            case 0: echo 'Failed'; break;
                            case 1: echo 'Completed'; break;
                            case 2: echo 'Processing'; break;
                            case 3: echo 'Payment TimeOut'; break; 
                          }
                        ?>
                      </th>
                      <td class="center">  
                        <a class="cpoint text-primary" id="viewHotelBooking" 
                           booking_id="<?= encode_param($booking->hotel_book_id) ?>">
                          <i class="fa fa-fw fa-eye"></i>View
                        </a> <br>
                      </td>
                    </tr>
                <?php } } ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>