<?php
defined('BASEPATH') OR exit('No direct script access allowed');
if (isset($_SERVER['HTTP_ORIGIN'])) {
  header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
  header('Access-Control-Allow-Credentials: true');
  header('Access-Control-Max-Age: 86400'); 
}

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
  if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS");         

  if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
    header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

  exit(0);
}
//test changes
class FlightServices extends CI_Controller {
  var $auth_token;

  public function __construct() {
    parent::__construct();
    date_default_timezone_set("Asia/Riyadh");
    $this->load->model('FlightServices_model');   
    $this->load->model('Validation_flight_model');
    $method = $this->router->fetch_method();  
    $data = (array) json_decode(file_get_contents('php://input'));
    if (isset(apache_request_headers()['Auth']) || isset(apache_request_headers()['auth'])) {
      $this->auth_token = (isset(apache_request_headers()['Auth']))?apache_request_headers()['Auth']:apache_request_headers()['auth'];
      $data['auth_token'] = $this->auth_token;
    }
    $res = $this->Validation_flight_model->validation_check($method, $data);
    if($res['state'] == 1) {
      $this->errorResponse($res['response']['code'], $res['response']['message']);
      die;
    }     
  }

  public function response($data) {
    $result =  array(
      'status' => 'success',
      'data' =>$data
    );
    print json_encode($result);
  }

  public function successResponse($data='') {
    $result =  array(
      'status' => 'success',
    );
    print json_encode($result);
  }

  public function errorResponse($errorCode, $errorDesc) {
    $result =  array(
      'status' => 'error',
      'error'=> $errorCode,
      'message'=> $errorDesc
    );
    print json_encode($result);
  }

  public function flight_authenticate(){
    $data = (array)json_decode(file_get_contents('php://input'));
    $data['auth_token'] = $this->auth_token;
    $res = $this->FlightServices_model->flight_authenticate($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  } 

  public function flight_availability_search(){
    $data = (array)json_decode(file_get_contents('php://input'));
    $data['auth_token'] = $this->auth_token;
    $res = $this->FlightServices_model->flight_availability_search($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  }

  public function flight_fare_rules(){
    $data = (array)json_decode(file_get_contents('php://input'));
    $data['auth_token'] = $this->auth_token;
    $res = $this->FlightServices_model->flight_fare_rules($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  }

  public function flight_revalidate(){
    $data = (array)json_decode(file_get_contents('php://input'));
    $data['auth_token'] = $this->auth_token;
    $res = $this->FlightServices_model->flight_revalidate($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  }

  public function flight_book(){
    $data = (array)json_decode(file_get_contents('php://input'));
    $data['auth_token'] = $this->auth_token;
    $res = $thia->FlightServices_model->flight_book($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  }

  public function flight_ticket_order(){
    $data = (array)json_decode(file_get_contents('php://input'));
    $data['auth_token'] = $this->auth_token;
    $res = $this->FlightServices_model->flight_ticket_order($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  }

  public function flight_trip_details(){
    $data = (array)json_decode(file_get_contents('php://input'));
    $data['auth_token'] = $this->auth_token;
    $res = $this->FlightServices_model->flight_trip_details($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  }

  public function cancel_flights(){
    $data = (array)json_decode(file_get_contents('php://input'));
    $data['auth_token'] = $this->auth_token;
    $res = $this->FlightServices_model->cancel_flights($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  }

  public function airportSearch(){
    $data = $_GET;
    $data['auth_token'] = $this->auth_token;
    $res = $this->FlightServices_model->airportSearch($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  }

  public function flight_details(){
    $data = (array)json_decode(file_get_contents('php://input'));
    $data['auth_token'] = $this->auth_token;
    $res = $this->FlightServices_model->flight_details($data);
    if($res['status'] == 1){
      $this->response($res['data']);
    }else{
      $this->errorResponse($res['code'],$res['message']);
    }
  }
}
?>
